% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/branch.R
\name{branch}
\alias{branch}
\alias{git_branch_list}
\alias{git_branch_checkout}
\alias{git_branch_create}
\alias{git_branch_delete}
\alias{git_branch_fast_forward}
\title{Git Branch}
\usage{
git_branch_list(repo = ".")

git_branch_checkout(branch, force = FALSE, repo = ".")

git_branch_create(name, ref = "HEAD", checkout = TRUE, repo = ".")

git_branch_delete(name, repo = ".")

git_branch_fast_forward(ref, repo = ".")
}
\arguments{
\item{repo}{a path to an existing repository, or a \code{git_repository} object as
returned by \link{git_open},  \link{git_init} or \link{git_clone}.}

\item{branch}{name of branch to check out}

\item{force}{ignore conflicts and overwrite modified files}

\item{name}{string with name of the branch / tag / etc}

\item{ref}{string with a branch/tag/commit}

\item{checkout}{move HEAD to the newly created branch}
}
\description{
Create, list, and checkout branches.
}
\seealso{
Other git: \code{\link{commit}}, \code{\link{fetch}},
  \code{\link{git_config}}, \code{\link{repository}},
  \code{\link{signature}}
}
\concept{git}
