% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MeanGermPercent.R
\name{MeanGermPercent}
\alias{MeanGermPercent}
\alias{MeanGermNumber}
\title{Mean germination percentage and number of seeds per time interval}
\usage{
MeanGermPercent(germinated.seeds, germ.counts, total.seeds, intervals,
  partial = TRUE)

MeanGermNumber(germ.counts, intervals, partial = TRUE)
}
\arguments{
\item{germinated.seeds}{Number of germinated seeds}

\item{germ.counts}{Germination counts at each time interval. Can be partial
or cumulative as specified in the argument \code{partial}.}

\item{total.seeds}{Total number of seeds.}

\item{intervals}{The time intervals.}

\item{partial}{logical. If \code{TRUE}, \code{germ.counts} is considered as
partial and if \code{FALSE}, it is considered as cumulative. Default is
\code{TRUE}.}
}
\value{
The value of mean germination percentage or mean number of seeds per
  time interval.
}
\description{
Compute the following metrics:\describe{ \item{\code{MeanGermPercent}}{
Mean/average germination percentage per unit time
(\ifelse{html}{\out{<em><span
style="text-decoration:overline">GP</span></em>}}{\eqn{\overline{GP}}})
\insertCite{czabator_germination_1962}{germinationmetrics}. }
\item{\code{MeanGermNumber}}{ Number of seeds germinated per unit time
(\ifelse{html}{\out{<em><span style="text-decoration:
overline">N</span></em>}}{\eqn{\overline{N}}})
\insertCite{khamassi_optimal_2013}{germinationmetrics}.}}
}
\details{
Mean germination percentage per unit time (\ifelse{html}{\out{<em><span
style="text-decoration:overline">GP</span></em>}}{\eqn{\overline{GP}}}) is
computed as follows
\insertCite{czabator_germination_1962}{germinationmetrics}.

\ifelse{html}{\out{<p style="text-align: center;"><em><span
style="text-decoration: overline;">GP</span> = <sup>GP</sup> &frasl;
<sub>T<sub>n</sub></sub></em></p>}}{\deqn{\overline{G} =
\frac{GP}{T_{n}}}{MGP = GP/Tf}}

Where, \ifelse{html}{\out{<i>GP</i>}}{\eqn{GP}} is the final germination
percentage and \ifelse{html}{\out{<em>T<sub>n</sub></em>}}{\eqn{T_{n}}} is
the total number of intervals(e.g. days) required for final germination.

Mean number of seeds germinated per unit time (\ifelse{html}{\out{<em><span
style="text-decoration: overline">N</span></em>}}{\eqn{\overline{N}}}) is
computed as follows \insertCite{khamassi_optimal_2013}{germinationmetrics}.

\ifelse{html}{\out{<p style="text-align: center;"><em><span
style="text-decoration: overline;">N</span> = <sup>N<sub>g</sub></sup>
&frasl; <sub>T<sub>n</sub></sub></em></p>}}{\deqn{\overline{N} =
\frac{N_{g}}{T_{n}}}}

Where, \ifelse{html}{\out{<em>N<sub>g</sub></em>}}{\eqn{N_{g}}} is the number
of germinated seeds and
\ifelse{html}{\out{<em>T<sub>n</sub></em>}}{\eqn{T_{n}}} is the total number
of intervals (e.g. days) required for final germination.
}
\examples{
x <- c(0, 0, 0, 0, 4, 17, 10, 7, 1, 0, 1, 0, 0, 0)
y <- c(0, 0, 0, 0, 4, 21, 31, 38, 39, 39, 40, 40, 40, 40)
int <- 1:length(x)

# From partial germination counts
#----------------------------------------------------------------------------
MeanGermPercent(germ.counts = x, total.seeds = 50, intervals = int)
MeanGermNumber(germ.counts = x, intervals = int)

# From cumulative germination counts
#----------------------------------------------------------------------------
MeanGermPercent(germ.counts = y, total.seeds = 50, intervals = int, partial = FALSE)
MeanGermNumber(germ.counts = y, intervals = int, partial = FALSE)

# From number of germinated seeds
#----------------------------------------------------------------------------
MeanGermPercent(germinated.seeds = 40, total.seeds = 50, intervals = int)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link[germinationmetrics]{GermPercent}}
}
