% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_terra_tiles.R
\name{set_window}
\alias{set_window}
\title{Copy a raster within a window}
\usage{
set_window(raster, window)
}
\arguments{
\item{raster}{a SpatRaster object.}

\item{window}{a SpatExtent object defining the area of interest.}
}
\value{
SpatRaster
}
\description{
Create a new SpatRaster object as specified by a window (area of interest)
over the original SpatRaster. This is a wrapper around \code{\link[terra:window]{terra::window()}}
which, rather than modifying the SpatRaster in place, returns a new
SpatRaster leaving the original unchanged.
}
\note{
While this may have general use, it was created primarily for use
within \code{\link[=tar_terra_tiles]{tar_terra_tiles()}}.
}
\examples{
f <- system.file("ex/elev.tif", package="terra")
r <- terra::rast(f)
e <- terra::ext(c(5.9, 6,49.95, 50))
r2 <- set_window(r, e)
terra::ext(r)
terra::ext(r2)

}
\author{
Eric Scott
}
