% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/york.R
\name{ellipse}
\alias{ellipse}
\title{ellipse}
\usage{
ellipse(mean, cov, alpha = 0.05, n = 50)
}
\arguments{
\item{mean}{two-element vector with the centre of the ellipse}

\item{cov}{the \code{2 x 2} covariance matrix of \code{x} and \code{y}}

\item{alpha}{confidence level of the ellipse}

\item{n}{the number of points at which the ellipse is evaluated}
}
\value{
a two-column matrix of plot coordinates
}
\description{
Compute the x-y coordinates of an error ellipse.
}
\examples{
X <- rnorm(100,mean=100,sd=1)
Y <- rnorm(100,mean=100,sd=1)
Z <- rnorm(100,mean=100,sd=5)
dat <- cbind(X/Z,Y/Z)
plot(dat)
ell <- ellipse(mean=colMeans(dat),cov=cov(dat))
polygon(ell)
}
