% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convenience-functions.R
\name{waic}
\alias{waic}
\title{WAIC}
\source{
Watanabe, S. (2010). Asymptotic equivalence of Bayes cross validation and widely application information criterion in singular learning theory. Journal of Machine Learning Research 11, 3571-3594.
}
\usage{
waic(fit, pointwise = FALSE, digits = 2)
}
\arguments{
\item{fit}{An \code{geostan_fit} object or any Stan model with a parameter named "log_lik", the pointwise log likelihood of the observations.}

\item{pointwise}{Logical (defaults to \code{FALSE}), should a vector of values for each observation be returned?}

\item{digits}{Round results to this many digits.}
}
\value{
A vector of length 3 with \code{WAIC}, a rough measure of the effective number of parameters estimated by the model \code{Eff_pars}, and log predictive density \code{Lpd}. If \code{pointwise = TRUE}, results are returned in a \code{data.frame}.
}
\description{
Widely Application Information Criteria (WAIC) for model comparison
}
\examples{
data(georgia)
fit <- stan_glm(log(rate.male) ~ 1, data = georgia,
                chains = 2, iter = 800) # for speed only
waic(fit)
}
\seealso{
\code{\link[loo]{waic}} \code{\link[loo]{loo}}
}
