% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convenience-functions.R
\name{sim_sar}
\alias{sim_sar}
\title{Simulate spatially autocorrelated data}
\usage{
sim_sar(m = 1, mu = rep(0, nrow(w)), w, rho, sigma = 1, ...)
}
\arguments{
\item{m}{The number of samples required. Defaults to \code{m=1} to return an \code{n}-length vector; if \code{m>1}, an \code{m x n} matrix is returned (i.e. each row will contain a sample of correlated values).}

\item{mu}{An \code{n}-length vector of mean values. Defaults to a vector of zeros with length equal to \code{nrow(w)}.}

\item{w}{Row-standardized \code{n x n} spatial weights matrix.}

\item{rho}{Spatial autocorrelation parameter in the range (-1, 1). Typically a scalar value; otherwise an n-length numeric vector.}

\item{sigma}{Scale parameter (standard deviation). Defaults to \code{sigma = 1}. Typically a scalar value; otherwise an n-length numeric vector.}

\item{...}{further arguments passed to \code{MASS::mvrnorm}.}
}
\value{
If \code{m = 1} a vector of the same length as \code{mu}, otherwise an \code{m x length(mu)} matrix with one sample in each row.
}
\description{
Given a spatial weights matrix and degree of autocorrelation, returns autocorrelated data.
}
\details{
Calls \code{MASS::mvrnorm} internally to draw from the multivariate normal distribution. The covariance matrix is specified following the simultaneous autoregressive (SAR) model.
}
\examples{
data(georgia)
w <- shape2mat(georgia, "W")
x <- sim_sar(w = w, rho = 0.5)
aple(x, w)

x <- sim_sar(w = w, rho = 0.7, m = 10)
dim(x)
apply(x, 1, aple, w = w)
}
\seealso{
\code{\link[geostan]{aple}}, \code{\link[geostan]{mc}}, \code{\link[geostan]{moran_plot}}, \code{\link[geostan]{lisa}}, \code{\link[geostan]{shape2mat}}
}
