% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posterior_predict.R
\name{posterior_predict}
\alias{posterior_predict}
\title{Draw samples from the posterior predictive distribution}
\usage{
posterior_predict(object, S, summary = FALSE, width = 0.95, car_parts, seed)
}
\arguments{
\item{object}{A \code{geostan_fit} object.}

\item{S}{Optional; number of samples to take from the posterior distribution. The default, and maximum, is the total number of samples stored in the model.}

\item{summary}{Should the predictive distribution be summarized by its means and central quantile intervals? If \code{summary = FALSE}, an \code{S} x \code{N} matrix of samples will be returned. If \code{summary = TRUE}, then a \code{data.frame} with the means and \code{100*width} credible intervals is returned.}

\item{width}{Only used if \code{summary = TRUE}, to set the quantiles for the credible intervals. Defaults to \code{width = 0.95}.}

\item{car_parts}{Data for CAR model specification; only required for \code{\link[geostan]{stan_car}} with \code{family = auto_gaussian()}.}

\item{seed}{A single integer value to be used in a call to \code{\link[base]{set.seed}} before taking samples from the posterior distribution.}
}
\value{
A matrix of size S x N containing samples from the posterior predictive distribution, where S is the number of samples drawn and N is the number of observations. If \code{summary = TRUE}, a \code{data.frame} with N rows and 3 columns is returned (with column names \code{mu}, \code{lwr}, and \code{upr}).
}
\description{
Draw samples from the posterior predictive distribution of a fitted \code{geostan} model.
}
\examples{
 fit <- stan_glm(sents ~ offset(log(expected_sents)),
                  re = ~ name,
                  data = sentencing,
                  family = poisson(),
                  chains = 2, iter = 600) # for speed only

 yrep <- posterior_predict(fit, S = 65)
 plot(density(yrep[1,]))
 for (i in 2:nrow(yrep)) lines(density(yrep[i,]), col = 'gray30')
 lines(density(sentencing$sents), col = 'darkred', lwd = 2)
}
