% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/09-correlation.R
\name{calculate_spatial_correlation}
\alias{calculate_spatial_correlation}
\title{Calculate spatial correlation between raster layers}
\usage{
calculate_spatial_correlation(
  raster1,
  raster2,
  method = "pearson",
  local_correlation = FALSE,
  window_size = 3
)
}
\arguments{
\item{raster1}{First raster layer}

\item{raster2}{Second raster layer}

\item{method}{Correlation method: "pearson", "spearman", "kendall"}

\item{local_correlation}{Calculate local correlation using moving window}

\item{window_size}{Window size for local correlation (in pixels)}
}
\value{
Correlation coefficient or SpatRaster of local correlations
}
\description{
Calculate spatial correlation between two raster layers using various methods.
Supports pixel-wise correlation and local correlation analysis.
}
\examples{
\dontrun{
# These examples require external data files not included with the package
# Global correlation between NDVI and soil nitrogen
correlation <- calculate_spatial_correlation(ndvi_raster, nitrogen_raster)

# Local correlation with moving window
local_corr <- calculate_spatial_correlation(
  ndvi_raster, nitrogen_raster,
  local_correlation = TRUE,
  window_size = 5
)
}

}
