% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geo_sed.R
\name{geo_sed}
\alias{geo_sed}
\title{Smallest circle encompassing all latitude and longitude points}
\usage{
geo_sed(coordinate_matrix)
}
\arguments{
\item{coordinate_matrix}{A matrix of latitude and longitude columns and any chosen number of rows to generate a smallest circle arround}
}
\value{
Returns a list of three elements named radius, center and making. Radius contains a single value representing the circle radius. Center contains a vector of length 2 representing the circle center latitude and longitude. Making contains a matrix of the latitude and longitude points that lie on the final smallest circle circumference.
}
\description{
Generates a center point and radius that represent the smallest circle that contains all input points
}
\examples{

# Load required packages
require(mapview)
require(sp)

# Create sample geo dataset
sample_coord <-
   matrix(
        c(
            sample(327131680:419648450, 10) / 10000000,
            sample(-1147301410:-1241938690, 10) / 10000000
        ),
        ncol = 2
    )

# Generate sed center and radius
gsc <- geo_sed(sample_coord)

# Create 80 sided polygon based on gsc's center and radius
gsc_poly <- geo_surround_poly(gsc$center, gsc$radius, 80)

# Join all the points into a single matrix
bound_poly <- rbind(sample_coord, gsc$center, gsc_poly)

# Create SpacialPoints object and pass to mapview for visualization
mapview(
    SpatialPoints(
        bound_poly[,c(2, 1)],
        proj4string = CRS("+proj=longlat +datum=WGS84")
    )
)


}
\seealso{
\code{\link{geo_trivial_circle}} \code{\link{geo_point_dist}}
}
\author{
Shant Sukljian
}
\keyword{circle}
\keyword{disk}
\keyword{enclosing}
\keyword{geo}
\keyword{latitude}
\keyword{longitude}
\keyword{sed}
\keyword{smallest}
