% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GNLegacyAPIManager.R
\docType{class}
\name{GNLegacyAPIManager}
\alias{GNLegacyAPIManager}
\title{GNLegacyAPIManager}
\format{
\code{\link{R6Class}} object.
}
\value{
Object of \code{\link{R6Class}} with methods for communication with
the REST API of a GeoNetwork instance using the legacy API.
}
\description{
GNLegacyAPIManager
}
\section{Abstract Methods}{

\describe{
 \item{\code{new(url, user, pwd, version, logger, keyring_backend)}}{
   This method is used to instantiate a GNLegacyAPIManager with the \code{url} of the
   GeoNetwork and credentials to authenticate (\code{user}/\code{pwd}).
   
   The \code{keyring_backend} can be set to use a different backend for storing 
   the Geonetwork password/token with \pkg{keyring} (Default value is 'env').
   
   The logger can be either NULL, "INFO" (with minimum logs), or "DEBUG" 
   (for complete curl http calls logs)
 }
 \item{\code{logger(type, text)}}{
   Basic logger to report geonapi logs. Used internally
 }
 \item{\code{INFO(text)}}{
   Logger to report information. Used internally
 }
 \item{\code{WARN(text)}}{
   Logger to report warnings. Used internally
 }
 \item{\code{ERROR(text)}}{
   Logger to report errors. Used internally
 }
 \item{\code{getUrl()}}{
   Get the authentication URL
 }
 \item{\code{getLang()}}{
   Get the service lang
 }
}
}

\section{Methods}{

\describe{
 \item{\code{new(url, user, pwd, version, logger, keyring_backend)}}{
   This method is used to instantiate a GNLegacyAPIManager with the \code{url} of the
   GeoNetwork and credentials to authenticate (\code{user}/\code{pwd}).
   
   The \code{keyring_backend} can be set to use a different backend for storing 
   the Geonetwork password/token with \pkg{keyring} (Default value is 'env').
   
   The logger can be either NULL, "INFO" (with minimum logs), or "DEBUG" 
   (for complete curl http calls logs)
 }
 \item{\code{login(user, pwd)}}{
   This methods attempts a connection to GeoNetwork REST API. User internally
   during initialization of \code{GNLegacyAPIManager}.
 }
 \item{\code{getGroups()}}{
   Retrieves the list of user groups available in Geonetwork
 }
 \item{\code{getCategories()}}{
   Retrieves the list of categories available in Geonetwork
 }
 \item{\code{insertMetadata(xml, file, geometa, group, category, stylesheet, validate, geometa_validate, geometa_inspire)}}{
   Inserts a metadata by file, XML object or \pkg{geometa} object of class
   \code{ISOMetadata} or \code{ISOFeatureCatalogue}. If successful, returns the Geonetwork
   metadata internal identifier (integer). Extra parameters \code{geometa_validate} (TRUE 
   by default) and \code{geometa_inspire} (FALSE by default) can be used with geometa objects 
   for perform ISO and INSPIRE validation respectively.
 }
 \item{\code{setPrivConfiguration(id, config)}}{
   Set the privilege configuration for a metadata. 'id' is the metadata integer id.
   'config' is an object of class "GNPrivConfiguration".
 }
 \item{\code{get(id, by, output)}}{
   Generic getter for metadata. Possible values for by are 'id', 'uuid'. Used
   internally only. The 'output' argument gives the type of output to return,
   with possible values "id", "metadata", "info".
 }
 \item{\code{getMetadataByID(id)}}{
   Get a metadata by Id. Returns an object of class \code{ISOMetadata} (ISO 19115)
   or \code{ISOFeatureCatalogue} (ISO 19110) (from \pkg{geometa} package)
 }
 \item{\code{getMetadataByUUID(uuid)}}{
   Get a metadata by UUID. Returns an object of class \code{ISOMetadata} (ISO 19115)
   or \code{ISOFeatureCatalogue} (ISO 19110) (from \pkg{geometa} package)
 }
 \item{\code{getInfoByID(id)}}{
   Get a metadata Info by Id. Returns an XML document object
 }
 \item{\code{getInfoByUUID(uuid)}}{
   Get a metadata Info by UUID. Returns an XML document object
 }
 \item{\code{updateMetadata(id, xml, file, geometa, geometa_validate, geometa_inspire)}}{
   Updates a metadata by file, XML object or \pkg{geometa} object of class
   'ISOMetadata' or 'ISOFeatureCatalogue'. Extra parameters \code{geometa_validate} (TRUE 
   by default) and \code{geometa_inspire} (FALSE by default) can be used with geometa objects 
   for perform ISO and INSPIRE validation respectively.
 }
 \item{\code{deleteMetadata(id)}}{
   Deletes a metadata
 }
 \item{\code{deleteMetadataAll()}}{
   Deletes all metadata for which the authenticated user is owner
 }
}
}

\examples{
\dontrun{
   GNLegacyAPIManager$new("http://localhost:8080/geonetwork", "admin", "geonetwork", "3.0.0")
}

}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{api}
\keyword{geonetwork}
\keyword{rest}
