% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gt_skew.R
\name{gt_skew}
\alias{gt_skew}
\title{Skew geometric objects}
\usage{
gt_skew(obj, x = NULL, y = NULL, fid = NULL, update = TRUE)
}
\arguments{
\item{obj}{[\code{geometric object(1)}]\cr the object to skew.}

\item{x}{[\code{numeric(1)}]\cr the shear factor in x dimension.}

\item{y}{[\code{numeric(1)}]\cr the shear factor in y dimension.}

\item{fid}{[\code{integerish(.)}]\cr if only a subset of features shall be
skewed, specify that here.}

\item{update}{[\code{logical(1)}]\cr whether or not to update the window slot
after skewing.}
}
\value{
\code{geom} of the skewed \code{obj}.
}
\description{
Skew geometric objects by a shear factor in x and y dimension.
}
\examples{
# skew several features
visualise(gtGeoms$polygon, linewidth = 3)
newPoly <- gt_skew(obj = gtGeoms$polygon, x = 0.5, update = FALSE)
visualise(geom = newPoly, linecol = "green", new = FALSE)

# skew a single feature
visualise(gtGeoms$polygon, linewidth = 3)
newPoly <- gt_skew(obj = gtGeoms$polygon, x = 0.5, y = .7, fid = 2,
                   update = FALSE)
visualise(newPoly, linecol = "green", new = FALSE)
}
\seealso{
Other geometry tools: 
\code{\link{gt_filter}()},
\code{\link{gt_locate}()},
\code{\link{gt_pull}()},
\code{\link{gt_reflect}()},
\code{\link{gt_rotate}()},
\code{\link{gt_scale}()},
\code{\link{gt_stretch}()},
\code{\link{gt_translate}()}
}
\concept{geometry tools}
