% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GMLBaseUnit.R
\docType{class}
\name{GMLBaseUnit}
\alias{GMLBaseUnit}
\title{GMLBaseUnit}
\format{
\code{\link{R6Class}} object.
}
\value{
Object of \code{\link{R6Class}} for modelling an GML base unit
}
\description{
GMLBaseUnit
}
\section{Fields}{

\describe{
\item{\code{unitsSystem}}{}
}}

\section{Methods}{

\describe{
 \item{\code{new(xml, defaults, id)}}{
   This method is used to instantiate a GML Base Unit
 }
 \item{\code{setUnitsSystem(unitsSystem)}}{
   Set the unit system
 }
}
}

\examples{
  gml <- GMLBaseUnit$new()
  gml$setDescriptionReference("someref")
  gml$setIdentifier("identifier", "codespace")
  gml$addName("name1", "codespace")
  gml$addName("name2", "codespace")
  gml$setQuantityTypeReference("someref")
  gml$setCatalogSymbol("symbol")
  gml$setUnitsSystem("somelink")

}
\references{
ISO 19136:2007 Geographic Information -- Geographic Markup Language.
  http://www.iso.org/iso/iso_catalogue/catalogue_tc/catalogue_detail.htm?csnumber=32554 
  
  OGC Geography Markup Language. http://www.opengeospatial.org/standards/gml
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{GML}
\keyword{ISO}
\keyword{base}
\keyword{definition}
\keyword{unit}
