% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISODistribution.R
\docType{class}
\name{ISODistribution}
\alias{ISODistribution}
\title{ISODistribution}
\format{\code{\link{R6Class}} object.}
\usage{
ISODistribution
}
\value{
Object of \code{\link{R6Class}} for modelling an ISO Distribution
}
\description{
ISODistribution
}
\section{Fields}{

\describe{
\item{\code{transferOptions}}{}
}}

\section{Methods}{

\describe{
 \item{\code{new(xml)}}{
   This method is used to instantiate an ISODistribution
 }
 \item{\code{addFormat(format)}}{
   Adds a distribution format, object of class \code{ISOFormat}
 }
 \item{\code{delFormat(format)}}{
   Deletes a distribution format, object of class \code{ISOFormat}
 }
 \item{\code{addDistributor(distributor)}}{
   Adds a distributor, object of class \code{ISODistributor}
 }
 \item{\code{delDistributor(distributor)}}{
   Deletes a distributor, object of class \code{ISODistributor}
 }
 \item{\code{setDigitalTransferOptions(options)}}{
   Sets the digital transfer options
 }
}
}

\examples{
  md <- ISODistribution$new()
  
  dto <- ISODigitalTransferOptions$new()  
  for(i in 1:3){
   or <- ISOOnlineResource$new()
   or$setLinkage(paste0("http://somelink",i))
   or$setName(paste0("name",i))
   or$setDescription(paste0("description",i))
   or$setProtocol("WWW:LINK-1.0-http--link")
   dto$addOnlineResource(or)
  }
  md$setDigitalTransferOptions(dto)
  
  xml <- md$encode()
  
}
\references{
ISO 19115:2003 - Geographic information -- Metadata
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{ISO}
\keyword{distribution}
