% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GMLUnitDefinition.R
\docType{class}
\name{GMLUnitDefinition}
\alias{GMLUnitDefinition}
\title{GMLUnitDefinition}
\format{\code{\link{R6Class}} object.}
\usage{
GMLUnitDefinition
}
\value{
Object of \code{\link{R6Class}} for modelling an GML unit definition
}
\description{
GMLUnitDefinition
}
\section{Fields}{

\describe{
\item{\code{catalogSymbol}}{}
}}

\section{Methods}{

\describe{
 \item{\code{new(xml, defaults, id)}}{
   This method is used to instantiate a GML Definition
 }
 \item{\code{setQuantityTypeReference(ref)}}{
   Set the quantity type reference. The content is a reference to a remote value
 }
 \item{\code{setCatalogSymbol(symbol)}}{
   Sets the preferred lexical symbol used for this unit of measure
 
 }
}
}

\examples{
  gml <- GMLUnitDefinition$new()
  gml$setDescriptionReference("someref")
  gml$setIdentifier("identifier", "codespace")
  gml$addName("name1", "codespace")
  gml$addName("name2", "codespace")
  gml$setQuantityTypeReference("someref")
  gml$setCatalogSymbol("symbol")

}
\references{
ISO 19136:2007 Geographic Information -- Geographic Markup Language.
  http://www.iso.org/iso/iso_catalogue/catalogue_tc/catalogue_detail.htm?csnumber=32554 
  
  OGC Geography Markup Language. http://www.opengeospatial.org/standards/gml
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{GML}
\keyword{ISO}
\keyword{definition}
\keyword{unit}
