% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ISODataQuality.R
\docType{class}
\name{ISODataQuality}
\alias{ISODataQuality}
\title{ISODataQuality}
\format{\code{\link{R6Class}} object.}
\usage{
ISODataQuality
}
\value{
Object of \code{\link{R6Class}} for modelling an ISO DataQuality
}
\description{
ISODataQuality
}
\section{Fields}{

\describe{
\item{\code{scope}}{}

\item{\code{report}}{}

\item{\code{lineage}}{}
}}
\section{Methods}{

\describe{
 \item{\code{new(xml,value)}}{
   This method is used to instantiate an ISODataQuality
 }
 \item{\code{setScope(scope)}}{
   Sets the scope
 }
 \item{\code{addReport(report)}}{
   Adds a report
 }
 \item{\code{setLineage(lineage)}}{
   Sets the lineage
 }
}
}
\examples{
#create dataQuality object
  dq <- ISODataQuality$new()

  #add scope
  scope <- ISOScope$new()
  scope$setLevel("dataset")
  dq$setScope(scope)

  #add report
  dc <- ISODomainConsistency$new()
  result <- ISOConformanceResult$new()
  spec <- ISOCitation$new()
  spec$setTitle("specification title")
  spec$setAlternateTitle("specification alternate title")
  d <- ISODate$new()
  d$setDate(ISOdate(2015, 1, 1, 1))
  d$setDateType("publication")
  spec$addDate(d)
  result$setSpecification(spec)
  result$setExplanation("some explanation about the conformance")
  result$setPass(TRUE)
  dc$addResult(result)
  dq$addReport(dc)

  #add lineage
  lineage <- ISOLineage$new()
  lineage$setStatement("statement")
  dq$setLineage(lineage)

  #xml
  xml <- dq$encode()
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{ISO}
\keyword{data}
\keyword{quality}

