% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sratoolkit_functions.R
\name{prefetch}
\alias{prefetch}
\title{Download data from NCBI Sequence Read Archive in .sra format using FASP or HTTPS protocols}
\usage{
prefetch(queryMetadata_object, sratoolkitPath = "",
  outputDirectory = ".", arguments = "-p 1", prefetchHelp = FALSE)
}
\arguments{
\item{queryMetadata_object}{A list object returned from `queryMetadata` where one of the 
entities queried was `fastqMetadata`.}

\item{sratoolkitPath}{String. A path to a local copy of sratoolkit. Only necessary if sratoolkit
is not on your $PATH. Assumes executables are inside `bin`.}

\item{outputDirectory}{String. A path to the directory where you would like the files to be stored.}

\item{arguments}{A string variable of arguments to be passed directly to `prefetch`.
Defaults to "-p 1" to show progress.
Use prefetchHelp = TRUE to see a list of arguments.}

\item{prefetchHelp}{Logical. prefetchHelp = T will show the help page for `prefetch` and then quit.}
}
\value{
This function will not return anything within r. It simply downloads .sra files. It will print command line
stdout to the console, and also provide a start and end time and amount of time elapsed during the download.
}
\description{
`prefetch()` uses the SRAtoolkit command-line function `prefetch` to download .sra
files from all samples returned by a \code{\link{queryMetadata}} query of GEOME, when one of the
entities queried was `fastqMetadata`
}
\details{
This function works best with SRAtoolkit functions of version 2.9.6 or greater. \href{https://www.ncbi.nlm.nih.gov/sra/docs/toolkitsoft/}{SRAtoolkit} functions can (ideally)
be in your $PATH, or you can supply a path to them using the sratoolkitPath argument.

It downloads files to the current working directory unless a different one is assigned through outputDirectory.

`prefetch` will automatically use the Fast and Secure Protocol (FASP) in the \href{https://downloads.asperasoft.com/connect2/}{Aspera Connect}
package if the `ascp` executable is in your $PATH. Otherwise it will use HTTPS.

You can alternatively pass the path to `ascp` by using arguments="-a path/to/ascp"
}
\examples{
\donttest{
# Run a query of GEOME first
acaoli <- queryMetadata(
   entity = "fastqMetadata", 
   query = "genus = Acanthurus AND specificEpithet = olivaceus AND _exists_:bioSample",
   select=c("Event"))

#trim to 3 entries for expediency
acaoli$fastqMetadata<-acaoli$fastqMetadata[1:3,]
acaoli$Event<-acaoli$Event[1:3,]


prefetch(queryMetadata_object = acaoli)

fastqDump(queryMetadata_object = acaoli, filenames = "IDs", source = "local", cleanup = T)
}
}
\seealso{
\url{https://www.ncbi.nlm.nih.gov/sra/docs/toolkitsoft/} to download pre-compiled executables for sratoolkit or
\url{https://github.com/ncbi/sra-tools/wiki/Building-and-Installing-from-Source>} to install from source

Use `prefetch` in combination with \code{\link{fastqDump}} or \code{\link{fasterqDump}} to convert .sra files to .fastq.
}
