% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inputs-webprocess.R
\docType{methods}
\name{inputs<-}
\alias{inputs<-}
\alias{inputs}
\alias{inputs,webprocess-method}
\alias{inputs,xml_document-method}
\alias{inputs<-,webprocess,missing-method}
\alias{inputs<-,webprocess,character-method}
\alias{inputs<-,webprocess,list-method}
\title{inputs of webprocess}
\usage{
inputs(.Object, ...) <- value

inputs(.Object, ..., value)

\S4method{inputs}{webprocess}(.Object, ..., value)

\S4method{inputs}{xml_document}(.Object, ..., value)

\S4method{inputs}{webprocess,missing}(.Object, ...) <- value

\S4method{inputs}{webprocess,character}(.Object, ...) <- value

\S4method{inputs}{webprocess,list}(.Object, ...) <- value
}
\arguments{
\item{.Object}{a webprocessing object}

\item{\dots}{arguments matching fields in .Object's processInputs slot}

\item{value}{a field pair for .Object processInputs}

\item{.Object}{a webprocessing object}

\item{...}{arguments matching fields in .Object's processInputs slot}
}
\description{
The webprocess inputs are a list of parameter names and their associated values.  
These inputs are specific to an individual \code{algorithm} used by the webprocess, 
and are pulled in from the web with defaults. An NA value in an input field means that 
this parameter will be left out of the web processing request. NULL values are required fields 
for the post and must be populated. For some values, there are defaults used if NULL (e.g.,
the mean for 'STATISTIC' is "mean"). Only characters can be used in input fields, but 
booleans are changed to characters as 'true' and 'false'.

access or set the inputs of a webprocess
}
\examples{
wp <- webprocess(DELIMITER = 'TAB')
inputs(wp)

inputs(wp) <- list(DELIMITER = 'COMMA', SUMMARIZE_FEATURE_ATTRIBUTE = 'false')
inputs(wp)
inputs(wp, "DELIMITER")
inputs(wp, "DELIMITER") <- "TAB"
}
\keyword{internal}
