% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topojson_read.R
\name{topojson_read}
\alias{topojson_read}
\title{Read topojson from a local file or a URL}
\usage{
topojson_read(x, ...)
}
\arguments{
\item{x}{Path to a local file or a URL.}

\item{...}{Further args passed on to \code{\link[sf]{st_read}}}
}
\value{
an object of class \code{sf}/\code{data.frame}
}
\description{
Read topojson from a local file or a URL
}
\details{
Returns a \code{sf} class, but you can easily and quickly get 
this to geojson, see examples. 

Note that this does not give you Topojson, but gives you a \code{sf}
class - which you can use then to turn it into geojson as a list or json
}
\examples{
\dontrun{
# From a file
file <- system.file("examples", "us_states.topojson", package = "geojsonio")
topojson_read(file)

# From a URL
url <- "https://raw.githubusercontent.com/shawnbot/d3-cartogram/master/data/us-states.topojson"
topojson_read(url)

# Use as.location first if you want
topojson_read(as.location(file))

# quickly convert to geojson as a list
file <- system.file("examples", "us_states.topojson", package = "geojsonio")
tmp <- topojson_read(file)
geojson_list(tmp)
geojson_json(tmp)

# pass on args
topojson_read(file, quiet = TRUE)
topojson_read(file, stringsAsFactors = FALSE)
}
}
\seealso{
\code{\link{geojson_read}}, \code{\link{topojson_write}}
}
