% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/georef.R
\name{georef_fwd}
\alias{georef_fwd}
\alias{georef_rev}
\title{World Geographic Reference System (Georef)}
\usage{
georef_fwd(x, precision = 2L)

georef_rev(georef)
}
\arguments{
\item{x}{A two-column matrix or data frame of coordinates (longitude, latitude)
in decimal degrees, or a list with longitude and latitude components.
Can also be a length-2 numeric vector for a single point.}

\item{precision}{Integer specifying the precision level (-1 to 11):
\itemize{
\item -1: 15-degree cells (2-character code)
\item 0: 1-degree cells (4-character code)
\item 1: 1-minute cells (6-character code)
\item 2: 0.1-minute cells (8-character code)
\item Higher values give progressively finer precision
}}

\item{georef}{Character vector of Georef codes to convert back to coordinates.}
}
\value{
\itemize{
\item \code{georef_fwd()}: Character vector of Georef codes.
\item \code{georef_rev()}: Data frame with columns:
\itemize{
\item \code{lon}: Longitude of cell center in decimal degrees
\item \code{lat}: Latitude of cell center in decimal degrees
\item \code{precision}: Precision level
\item \code{lat_resolution}: Cell half-height in degrees
\item \code{lon_resolution}: Cell half-width in degrees
}
}
}
\description{
Convert geographic coordinates (longitude/latitude) to World Geographic
Reference System (Georef) codes, or convert Georef codes back to coordinates.
}
\details{
The World Geographic Reference System (Georef) is a grid-based geocode
system used primarily for air navigation. It was developed by the US
and adopted by ICAO (International Civil Aviation Organization).

The Georef code structure:
\itemize{
\item First letter: 15° longitude band (A-Z, omitting I and O)
\item Second letter: 15° latitude band (A-M, omitting I)
\item Third letter: 1° longitude within band (A-Q, omitting I and O)
\item Fourth letter: 1° latitude within band (A-Q, omitting I and O)
\item Remaining digits: minutes (and fractions) of longitude and latitude
}

Example: "GJPJ3217" represents approximately (0.54°, 51.28°)
}
\examples{
# Basic conversion
georef_fwd(c(-0.1, 51.5))

# Different precision levels
georef_fwd(c(-0.1, 51.5), precision = -1)  # 15-degree
georef_fwd(c(-0.1, 51.5), precision = 0)   # 1-degree
georef_fwd(c(-0.1, 51.5), precision = 1)   # 1-minute
georef_fwd(c(-0.1, 51.5), precision = 2)   # 0.1-minute

# Multiple points
pts <- cbind(lon = c(-74, 139.7, 0), lat = c(40.7, 35.7, 51.5))
georef_fwd(pts)

# Reverse conversion
georef_rev(c("GJPJ3217", "SKNA2342", "FJBL0630"))
}
\seealso{
\code{\link[=gars_fwd]{gars_fwd()}} for Global Area Reference System, \code{\link[=mgrs_fwd]{mgrs_fwd()}} for
Military Grid Reference System.
}
