% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acs_5yr_download.R
\name{select_area_files}
\alias{select_area_files}
\alias{select_area_files.acs_5yr}
\title{Select area files}
\usage{
select_area_files(ac, area, years)

\method{select_area_files}{acs_5yr}(ac, area, years = NULL)
}
\arguments{
\item{ac}{An \code{acs_5yr} object.}

\item{area}{A string, area name.}

\item{years}{A vector, year number.}
}
\value{
An \code{acs_5yr} object.
}
\description{
Select area files for the given years. If no year is indicated, all available
ones are selected.
}
\examples{

dir <- system.file("extdata/acs_5yr", package = "geogenr")
ac <- acs_5yr(dir)

ac <- ac |>
  select_area_files("State", 2019:2021)

ac <- ac |>
  select_area_files("State")

}
\seealso{
Other data download functions: 
\code{\link{acs_5yr}()},
\code{\link{download_selected_files}()},
\code{\link{get_area_file_names}()},
\code{\link{get_area_groups}()},
\code{\link{get_area_years}()},
\code{\link{get_areas}()},
\code{\link{get_selected_file_names}()},
\code{\link{get_too_heavy_file_names}()},
\code{\link{unzip_files}()}
}
\concept{data download functions}
