% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acs_5yr_download.R
\name{get_area_years}
\alias{get_area_years}
\alias{get_area_years.acs_5yr}
\title{Get available area years}
\usage{
get_area_years(ac, area)

\method{get_area_years}{acs_5yr}(ac, area)
}
\arguments{
\item{ac}{An \code{acs_5yr} object.}

\item{area}{A string, area name.}
}
\value{
A vector, area years.
}
\description{
Get the years for which data has been found to be available for an area.
}
\examples{

dir <- system.file("extdata/acs_5yr", package = "geogenr")
ac <- acs_5yr(dir)

years <- ac |>
  get_area_years(area = "State")

}
\seealso{
Other data download functions: 
\code{\link{acs_5yr}()},
\code{\link{download_selected_files}()},
\code{\link{get_area_file_names}()},
\code{\link{get_area_groups}()},
\code{\link{get_areas}()},
\code{\link{get_selected_file_names}()},
\code{\link{get_too_heavy_file_names}()},
\code{\link{select_area_files}()},
\code{\link{unzip_files}()}
}
\concept{data download functions}
