% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uscb_acs_5ye_get_geo.R
\name{get_available_years_in_the_web}
\alias{get_available_years_in_the_web}
\alias{get_available_years_in_the_web.uscb_acs_5ye}
\title{Get available years in the web}
\usage{
get_available_years_in_the_web(ua, geodatabase)

\method{get_available_years_in_the_web}{uscb_acs_5ye}(ua, geodatabase)
}
\arguments{
\item{ua}{A \code{uscb_acs_5ye} object.}

\item{geodatabase}{A string.}
}
\value{
A vector of integers.
}
\description{
For the name of a geodatabase, returns a vector with the years for which data
is available on the web.
}
\examples{
library(tidyr)

folder <- "../geodimension/data/us/"
ua <- uscb_acs_5ye(folder = folder)
sa <- ua \%>\% get_statistical_areas()

# sa[6]
# [1] "New England City and Town Area Division"
\donttest{
y <- ua \%>\% get_available_years_in_the_web(geodatabase = sa[6])
}
}
\seealso{


Other data collection functions: 
\code{\link{download_geodatabases}()},
\code{\link{get_available_years_downloaded}()},
\code{\link{get_legal_and_administrative_areas}()},
\code{\link{get_statistical_areas}()},
\code{\link{uscb_acs_5ye}()}
}
\concept{data collection functions}
