#' Geo Grids
#'
#' @name grids
#' @docType data
#' @keywords data
#' @description There are now 64 grids available in this package and more online. To view a full list of available grids, see [here](https://raw.githubusercontent.com/hafen/grid-designer/master/grid_list.json). To create and submit your own grid, see [here](https://hafen.github.io/grid-designer/). To see several examples of grids being used to visualize data, see \code{\link{facet_geo}}.
#' @rdname grids
#' @md
NULL

#' @name us_state_grid1
#' @description
#' * **us_state_grid1:** Grid layout for US states (including DC) Image reference [here](https://images7.alphacoders.com/687/687665.jpg).
#' @usage us_state_grid1
#' @rdname grids
#' @md
NULL

#' @name us_state_grid2
#' @description
#' * **us_state_grid2:** Grid layout for US states (including DC) Image reference [here](https://images7.alphacoders.com/687/687665.jpg).
#' @usage us_state_grid2
#' @rdname grids
#' @md
NULL

#' @name eu_grid1
#' @description
#' * **eu_grid1:** Grid layout for the 28 EU Countries Image reference [here](https://ichef.bbci.co.uk/news/660/media/images/70233000/gif/_70233868_eunames.gif).
#' @usage eu_grid1
#' @rdname grids
#' @md
NULL

#' @name aus_grid1
#' @description
#' * **aus_grid1:** Grid layout for the Australian States and Territories. Image reference [here](https://cloud.githubusercontent.com/assets/9496865/26334627/75a729d2-3fa5-11e7-88af-a1dd86b7ddf3.png). Thanks to [jonocarroll](https://github.com/jonocarroll).
#' @usage aus_grid1
#' @rdname grids
#' @md
NULL

#' @name sa_prov_grid1
#' @description
#' * **sa_prov_grid1:** Grid layout for the provinces of South Africa Image reference [here](https://camo.githubusercontent.com/a90b18a1ab0c36200da9b118141b997b3f22638e/687474703a2f2f7777772e6578706c6f7265736f7574686166726963612e6e65742f696d616765732f70726f766d61702e6a7067). Thanks to [jonmcalder](https://github.com/jonmcalder).
#' @usage sa_prov_grid1
#' @rdname grids
#' @md
NULL

#' @name london_boroughs_grid
#' @description
#' * **london_boroughs_grid:** Grid layout for the boroughs of London. Note that the column \code{code_ons} contains the \href{http://geoportal.statistics.gov.uk/datasets/464be6191a434a91a5fa2f52c7433333_0?uiTab=table}{codes} used by UK Office for National Statistics. Image reference [here](https://cloud.githubusercontent.com/assets/13021448/26399784/3133d684-4076-11e7-8eac-1e74d023bf18.jpg). Thanks to [eldenvo](https://github.com/eldenvo).
#' @usage london_boroughs_grid
#' @rdname grids
#' @md
NULL

#' @name nhs_scot_grid
#' @description
#' * **nhs_scot_grid:** Grid layout for a grid of NHS Scotland Health Boards. Note that the column \code{code} contains the \href{http://geoportal.statistics.gov.uk/datasets/61dca36aa33e4aee99bbfa784fa9eb25_0?uiTab=table}{codes} used by UK Office for National Statistics. Image reference [here](https://cloud.githubusercontent.com/assets/24879214/26426113/253658d0-40cf-11e7-88b5-fe5ee7fda44f.png). Thanks to [jsphdms](https://github.com/jsphdms).
#' @usage nhs_scot_grid
#' @rdname grids
#' @md
NULL

#' @name india_grid1
#' @description
#' * **india_grid1:** Grid layout for India states (not including union territories). Image reference [here](https://cloud.githubusercontent.com/assets/11698124/26569168/dd2ca86c-44bd-11e7-9d74-af919522f7b1.jpg). Thanks to [meysubb](https://github.com/meysubb).
#' @usage india_grid1
#' @rdname grids
#' @md
NULL

#' @name india_grid2
#' @description
#' * **india_grid2:** Grid layout for India states (not including union territories). Image reference [here](https://cloud.githubusercontent.com/assets/11698124/26569168/dd2ca86c-44bd-11e7-9d74-af919522f7b1.jpg).
#' @usage india_grid2
#' @rdname grids
#' @md
NULL

#' @name argentina_grid1
#' @description
#' * **argentina_grid1:** Grid for the 23 provinces of Argentina. It includes the Malvinas/Falkland Islands and the Antarctic Territories (these are disputed, but they are included since many researchers might use data from these locations). Image reference [here](https://s-media-cache-ak0.pinimg.com/736x/bf/cb/96/bfcb9654477c127d3b0e0b72d5be65fc.jpg). Thanks to [eliocamp](https://github.com/eliocamp).
#' @usage argentina_grid1
#' @rdname grids
#' @md
NULL

#' @name br_states_grid1
#' @description
#' * **br_states_grid1:** Grid for the 27 states of Brazil. Image reference [here](https://camo.githubusercontent.com/477627dce2610f18f1bf3850cd32fca01610656e/687474703a2f2f63656a656475696e66616e74696c2e7062776f726b732e636f6d2f662f313435383034313938342f4d61706142726173696c5369676c61732e676966). Thanks to [italocegatta](https://github.com/italocegatta).
#' @usage br_states_grid1
#' @rdname grids
#' @md
NULL

#' @name sea_grid1
#' @description
#' * **sea_grid1:** Grid for South East Asian countries. Image reference [here](https://camo.githubusercontent.com/694a275db0e89984f347ce8b49221352416d2c48/68747470733a2f2f7669676e65747465322e77696b69612e6e6f636f6f6b69652e6e65742f757461752f696d616765732f382f38322f536f757468656173745f617369612e6a70672f7265766973696f6e2f6c61746573743f63623d3230313130313230303431383034). Thanks to [jasonjb82](https://github.com/jasonjb82).
#' @usage sea_grid1
#' @rdname grids
#' @md
NULL

#' @name mys_grid1
#' @description
#' * **mys_grid1:** Grid for Malaysian states and territories. Image reference [here](https://camo.githubusercontent.com/cd22848f0b7b53d4ef7afc6d178a0e9579ecf2aa/68747470733a2f2f7777772e6d6170736f66776f726c642e636f6d2f6d616c61797369612f6d6170732f6d616c61797369612d706f6c69746963616c2d6d61702e6a7067). Thanks to [jasonjb82](https://github.com/jasonjb82).
#' @usage mys_grid1
#' @rdname grids
#' @md
NULL

#' @name fr_regions_grid1
#' @description
#' * **fr_regions_grid1:** Land and overseas regions of France. Codes are INSEE codes. Image reference [here](https://camo.githubusercontent.com/b526c357a4c30cdd2e90700c6559381348111377/687474703a2f2f7777772e6361727465736672616e63652e66722f6361727465732f67656f677261706869652f63617274652d726567696f6e732e6a7067). Thanks to [mtmx](https://github.com/mtmx).
#' @usage fr_regions_grid1
#' @rdname grids
#' @md
NULL

#' @name de_states_grid1
#' @description
#' * **de_states_grid1:** Grid for the German states ('Länder') Image reference [here](https://camo.githubusercontent.com/e144ebb2bdd2d82d8a4c34908cd68ab2b2388425/68747470733a2f2f75706c6f61642e77696b696d656469612e6f72672f77696b6970656469612f636f6d6d6f6e732f642f64332f5374617465735f6f665f4765726d616e792e737667). Thanks to [DominikVogel](https://github.com/DominikVogel).
#' @usage de_states_grid1
#' @rdname grids
#' @md
NULL

#' @name us_or_counties_grid1
#' @description
#' * **us_or_counties_grid1:** Grid for Oregon counties. Image reference [here](https://user-images.githubusercontent.com/11638312/27445795-01b77804-5730-11e7-919b-36cde8027706.jpg). Thanks to [aosmith16](https://github.com/aosmith16).
#' @usage us_or_counties_grid1
#' @rdname grids
#' @md
NULL

#' @name us_wa_counties_grid1
#' @description
#' * **us_wa_counties_grid1:** Grid for Washington counties. Image reference [here](http://www.countymapsofwashington.com/aapics/washingstate.gif).
#' @usage us_wa_counties_grid1
#' @rdname grids
#' @md
NULL

#' @name us_in_counties_grid1
#' @description
#' * **us_in_counties_grid1:** Grid for Indiana counties. Image reference [here](https://upload.wikimedia.org/wikipedia/commons/thumb/e/ec/Indiana_county_map.png/640px-Indiana_county_map.png). Thanks to [nateapathy](https://github.com/nateapathy).
#' @usage us_in_counties_grid1
#' @rdname grids
#' @md
NULL

#' @name us_in_central_counties_grid1
#' @description
#' * **us_in_central_counties_grid1:** Grid for central Indiana counties. Image reference [here](https://camo.githubusercontent.com/eb31e821890a0c600f59234fb184335c2bf84423/687474703a2f2f7777772e736176692e6f72672f77702d636f6e74656e742f75706c6f6164732f323031352f30322f6d61702d312e6a7067). Thanks to [nateapathy](https://github.com/nateapathy).
#' @usage us_in_central_counties_grid1
#' @rdname grids
#' @md
NULL

#' @name se_counties_grid1
#' @description
#' * **se_counties_grid1:** Grid for counties of Sweden. Image reference [here](http://www.worldatlas.com/webimage/countrys/europe/lgcolor/secounties.gif). Thanks to [duleise](https://github.com/duleise).
#' @usage se_counties_grid1
#' @rdname grids
#' @md
NULL

#' @name sf_bay_area_counties_grid1
#' @description
#' * **sf_bay_area_counties_grid1:** Grid of the 9 San Francisco Bay Area counties. Image reference [here](https://user-images.githubusercontent.com/1275592/28043128-53be650a-6585-11e7-920e-4ad9a13bf1a5.png). Thanks to [Eunoia](https://github.com/Eunoia).
#' @usage sf_bay_area_counties_grid1
#' @rdname grids
#' @md
NULL

#' @name ua_region_grid1
#' @description
#' * **ua_region_grid1:** Grid of administrative divisions of Ukraine (24 oblasts, one autonomous region, and two cities). Image reference [here](https://camo.githubusercontent.com/0615706478de63da2c7c3c3b21fe92c6db6a2fee/687474703a2f2f696d61676573312e66616e706f702e636f6d2f696d616765732f696d6167655f75706c6f6164732f556b7261696e69616e2d6d61702d756b7261696e652d313135333138375f3733305f3530352e676966). Thanks to [woldemarg](https://github.com/woldemarg).
#' @usage ua_region_grid1
#' @rdname grids
#' @md
NULL

#' @name mx_state_grid1
#' @description
#' * **mx_state_grid1:** Grid layout for the states of Mexico. Image reference [here](https://user-images.githubusercontent.com/1275592/28044555-ee236b2a-658c-11e7-96e5-3af124ca9619.png). Thanks to [ikashnitsky](https://github.com/ikashnitsky).
#' @usage mx_state_grid1
#' @rdname grids
#' @md
NULL

#' @name mx_state_grid2
#' @description
#' * **mx_state_grid2:** Grid layout for the states of Mexico. Image reference [here](https://user-images.githubusercontent.com/1275592/28044555-ee236b2a-658c-11e7-96e5-3af124ca9619.png). Thanks to [diegovalle](https://github.com/diegovalle).
#' @usage mx_state_grid2
#' @rdname grids
#' @md
NULL

#' @name scotland_local_authority_grid1
#' @description
#' * **scotland_local_authority_grid1:** Grid layout for the local authorities of Scotland. Image reference [here](https://user-images.githubusercontent.com/1275592/28044967-3b508570-658f-11e7-99b5-b1d73c765c2e.png). Thanks to [davidhen](https://github.com/davidhen).
#' @usage scotland_local_authority_grid1
#' @rdname grids
#' @md
NULL

#' @name us_state_grid3
#' @description
#' * **us_state_grid3:** Grid layout for US states (excluding DC) Image reference [here](https://images7.alphacoders.com/687/687665.jpg). Thanks to [ejr248](https://github.com/ejr248).
#' @usage us_state_grid3
#' @rdname grids
#' @md
NULL

#' @name italy_grid1
#' @description
#' * **italy_grid1:** Grid layout for regions of Italy (in collaboration with Stella Cangelosi and Luciana Dalla Valle). Image reference [here](https://user-images.githubusercontent.com/1275592/28291015-8f0abd66-6afd-11e7-9e2a-b4c1d4021c13.png). Thanks to [JulianStander](https://github.com/JulianStander).
#' @usage italy_grid1
#' @rdname grids
#' @md
NULL

#' @name italy_grid2
#' @description
#' * **italy_grid2:** Grid layout for regions of Italy (in collaboration with Stella Cangelosi and Luciana Dalla Valle). Image reference [here](https://user-images.githubusercontent.com/1275592/28291015-8f0abd66-6afd-11e7-9e2a-b4c1d4021c13.png). Thanks to [JulianStander](https://github.com/JulianStander).
#' @usage italy_grid2
#' @rdname grids
#' @md
NULL

#' @name be_province_grid1
#' @description
#' * **be_province_grid1:** Grid layout for provinces of Belgium plus Brussels, including names in three languages (French, Dutch, English) and Belgium internal codes (NIS). Image reference [here](https://camo.githubusercontent.com/efa2c894793585141da8f7b9789b184eacc8d781/687474703a2f2f7777772e657570656469612e636f6d2f696d616765732f636f6e74656e742f42656c6769756d5f526567696f6e732e676966). Thanks to [ericlecoutre](https://github.com/ericlecoutre).
#' @usage be_province_grid1
#' @rdname grids
#' @md
NULL

#' @name us_state_grid4
#' @description
#' * **us_state_grid4:** Grid layout for US states (including DC). Image reference [here](https://images7.alphacoders.com/687/687665.jpg). Thanks to [kanishkamisra](https://github.com/kanishkamisra).
#' @usage us_state_grid4
#' @rdname grids
#' @md
NULL

#' @name jp_prefs_grid1
#' @description
#' * **jp_prefs_grid1:** Grid layout for the prefectures of Japan. Image reference [here](https://camo.githubusercontent.com/bffec5ac4ae6507c1ca1b83570544f405b86b048/68747470733a2f2f75706c6f61642e77696b696d656469612e6f72672f77696b6970656469612f636f6d6d6f6e732f7468756d622f382f38372f49534f2d333136362d322d4a502e706e672f35313270782d49534f2d333136362d322d4a502e706e67). Thanks to [uribo](https://github.com/uribo).
#' @usage jp_prefs_grid1
#' @rdname grids
#' @md
NULL

#' @name ng_state_grid1
#' @description
#' * **ng_state_grid1:** Grid layout for the 37 Federal States of Nigeria. Image reference [here](https://camo.githubusercontent.com/fa12bca8fe3f3de3d7af707400adbc7fc4656cc3/68747470733a2f2f75706c6f61642e77696b696d656469612e6f72672f77696b6970656469612f636f6d6d6f6e732f382f38332f4e6967657269615f7374617465732e706e67). Thanks to [ghosthedirewolf](https://github.com/ghosthedirewolf).
#' @usage ng_state_grid1
#' @rdname grids
#' @md
NULL

#' @name bd_upazila_grid1
#' @description
#' * **bd_upazila_grid1:** Grid layout for Bangladesh 64 Upazilas. Image reference [here](https://camo.githubusercontent.com/df1e4aff5a3e0238afef97586d324d9b23acf27b/68747470733a2f2f75706c6f61642e77696b696d656469612e6f72672f77696b6970656469612f636f6d6d6f6e732f7468756d622f322f32382f42445f4d61705f61646d696e2e7376672f38303070782d42445f4d61705f61646d696e2e7376672e706e67). Thanks to [ghosthedirewolf](https://github.com/ghosthedirewolf).
#' @usage bd_upazila_grid1
#' @rdname grids
#' @md
NULL

#' @name spain_prov_grid1
#' @description
#' * **spain_prov_grid1:** Grid layout for Provinces of Spain. Image reference [here](https://user-images.githubusercontent.com/1275592/30189589-cbfbf2de-93e9-11e7-9598-bb4c4e09e0c1.png). Thanks to [kintero](https://github.com/kintero).
#' @usage spain_prov_grid1
#' @rdname grids
#' @md
NULL

#' @name ch_cantons_grid1
#' @description
#' * **ch_cantons_grid1:** Grid layout for Cantons of Switzerland. Image reference [here](https://camo.githubusercontent.com/b3c99e5725cdb60fd60a66731c8492fdb0e09ab6/68747470733a2f2f75706c6f61642e77696b696d656469612e6f72672f77696b6970656469612f636f6d6d6f6e732f342f34612f537769747a65726c616e642532435f61646d696e6973747261746976655f6469766973696f6e735f2d5f64655f2d5f636f6c6f7265642e737667). Thanks to [tinu-schneider](https://github.com/tinu-schneider).
#' @usage ch_cantons_grid1
#' @rdname grids
#' @md
NULL

#' @name ch_cantons_grid2
#' @description
#' * **ch_cantons_grid2:** Grid layout for Cantons of Switzerland. Image reference [here](https://user-images.githubusercontent.com/4510815/29034578-0485df5c-7b99-11e7-9ff8-67a7b687de12.png). Thanks to [rastrau](https://github.com/rastrau).
#' @usage ch_cantons_grid2
#' @rdname grids
#' @md
NULL

#' @name china_prov_grid1
#' @description
#' * **china_prov_grid1:** Grid layout for Provinces of China. Image reference [here](https://user-images.githubusercontent.com/1275592/30039720-cf9c8532-9189-11e7-856b-a6ecf449ee0c.png). Thanks to [weiyunna](https://github.com/weiyunna).
#' @usage china_prov_grid1
#' @rdname grids
#' @md
NULL

#' @name world_86countries_grid
#' @description
#' * **world_86countries_grid:** Grid layout for 86 countries in the world. Image reference [here](https://user-images.githubusercontent.com/1275592/30190118-0678aeb8-93ed-11e7-91b2-49738beb6f04.png). Thanks to [akangsha](https://github.com/akangsha).
#' @usage world_86countries_grid
#' @rdname grids
#' @md
NULL

#' @name se_counties_grid2
#' @description
#' * **se_counties_grid2:** Grid for counties of Sweden. Image reference [here](https://user-images.githubusercontent.com/6022947/31674182-71150350-b361-11e7-9873-ffe319344c90.jpg). Thanks to [richardohrvall](https://github.com/richardohrvall).
#' @usage se_counties_grid2
#' @rdname grids
#' @md
NULL

#' @name uk_regions1
#' @description
#' * **uk_regions1:** Grid for regions of the UK (aka EU standard NUTS 1 areas). Image reference [here](https://user-images.githubusercontent.com/1275592/32032394-d394b24a-b9bb-11e7-91e8-fe4da69ba005.jpg). Thanks to [paulb20](https://github.com/paulb20).
#' @usage uk_regions1
#' @rdname grids
#' @md
NULL

#' @name us_state_contiguous_grid1
#' @description
#' * **us_state_contiguous_grid1:** Grid layout for the contiguous US states (including DC). Image reference [here](https://images7.alphacoders.com/687/687665.jpg). Thanks to [andrewsr](https://github.com/andrewsr).
#' @usage us_state_contiguous_grid1
#' @rdname grids
#' @md
NULL

#' @name sk_province_grid1
#' @description
#' * **sk_province_grid1:** Grid layout for South Korean sis and dos (metropolitan/special/autonomous cities and provinces). Image reference [here](http://tong.visitkorea.or.kr/enu/images/koreastay/korea_map.jpg). Thanks to [heon131](https://github.com/heon131).
#' @usage sk_province_grid1
#' @rdname grids
#' @md
NULL

#' @name ch_aargau_districts_grid1
#' @description
#' * **ch_aargau_districts_grid1:** Grid layout for Districts of the Canton of Aargau, Switzerland. Image reference [here](https://user-images.githubusercontent.com/31518032/32281394-fcd761d0-bf1e-11e7-9dcc-ae52307eeafd.png). Thanks to [zumbov2](https://github.com/zumbov2).
#' @usage ch_aargau_districts_grid1
#' @rdname grids
#' @md
NULL

#' @name jo_gov_grid1
#' @description
#' * **jo_gov_grid1:** Grid layout for Governorates of Jordan. Image reference [here](https://camo.githubusercontent.com/a229e8b82407259265378f39e4b5f09dceace668/687474703a2f2f7777772e3234706f696e74302e636f6d2f7070742d73686f702f6d656469612f636174616c6f672f70726f647563742f63616368652f312f696d6167652f61313437653035336533386461386432366462626233626232346232313238302f6a2f6f2f6a6f7264616e2d676f7665726e6f726174652d6361706974616c732d6d61702d706f776572706f696e742d70726573656e746174696f6e2e6a7067). Thanks to [ghosthedirewolf](https://github.com/ghosthedirewolf).
#' @usage jo_gov_grid1
#' @rdname grids
#' @md
NULL

#' @name spain_ccaa_grid1
#' @description
#' * **spain_ccaa_grid1:** Grid layout for Spanish 'Comunidades Autónomas'. Image reference [here](https://camo.githubusercontent.com/5be0fc76e8dab5269761384ce2b77e7e79bba0db/68747470733a2f2f7777772e6d737373692e676f622e65732f6f7267616e697a6163696f6e2f636361612f696d672f737061696e2e6a7067). Thanks to [JoseAntonioOrtega](https://github.com/JoseAntonioOrtega).
#' @usage spain_ccaa_grid1
#' @rdname grids
#' @md
NULL

#' @name spain_prov_grid2
#' @description
#' * **spain_prov_grid2:** Grid layout for Provinces of Spain. Image reference [here](https://user-images.githubusercontent.com/1275592/30189589-cbfbf2de-93e9-11e7-9598-bb4c4e09e0c1.png). Thanks to [JoseAntonioOrtega](https://github.com/JoseAntonioOrtega).
#' @usage spain_prov_grid2
#' @rdname grids
#' @md
NULL

#' @name world_countries_grid1
#' @description
#' * **world_countries_grid1:** Grid layout for countries of the world, with a few exclusions. See . Image reference [here](https://user-images.githubusercontent.com/1275592/30189589-cbfbf2de-93e9-11e7-9598-bb4c4e09e0c1.png). Thanks to [JoseAntonioOrtega](https://github.com/JoseAntonioOrtega).
#' @usage world_countries_grid1
#' @rdname grids
#' @md
NULL

#' @name br_states_grid2
#' @description
#' * **br_states_grid2:** Grid for the 27 states of Brazil. Image reference [here](http://www.brazil-help.com/mapa_do_brasil.gif). Thanks to [hafen](https://github.com/hafen).
#' @usage br_states_grid2
#' @rdname grids
#' @md
NULL

#' @name china_city_grid1
#' @description
#' * **china_city_grid1:** Grid layout of cities in China. Image reference [here](). Thanks to [CharleneDeng1](https://github.com/CharleneDeng1).
#' @usage china_city_grid1
#' @rdname grids
#' @md
NULL

#' @name kr_seoul_district_grid1
#' @description
#' * **kr_seoul_district_grid1:** Grid layout of Seoul's 25 districts. Image reference [here](https://user-images.githubusercontent.com/1275592/38068875-494e49a8-32c8-11e8-8ace-b91982fe486f.png). Thanks to [yonghah](https://github.com/yonghah).
#' @usage kr_seoul_district_grid1
#' @rdname grids
#' @md
NULL

#' @name nz_regions_grid1
#' @description
#' * **nz_regions_grid1:** Grid layout for regions of New Zealand. Image reference [here](https://camo.githubusercontent.com/3db8d49d196be1e70ed0ebd4dcedf6fefc8fcfed/68747470733a2f2f75706c6f61642e77696b696d656469612e6f72672f77696b6970656469612f636f6d6d6f6e732f7468756d622f322f32312f4e5a5f526567696f6e616c5f436f756e63696c735f616e645f5465727269746f7269616c5f417574686f7269746965735f323031372e7376672f3130303070782d4e5a5f526567696f6e616c5f436f756e63696c735f616e645f5465727269746f7269616c5f417574686f7269746965735f323031372e7376672e706e67). Thanks to [pierreroudier](https://github.com/pierreroudier).
#' @usage nz_regions_grid1
#' @rdname grids
#' @md
NULL

#' @name sl_regions_grid1
#' @description
#' * **sl_regions_grid1:** Grid layout of Slovenian regions. Image reference [here](https://user-images.githubusercontent.com/1275592/38069181-df2cbcb0-32c9-11e8-8a5b-0528f3e9e81c.png). Thanks to [SR1986](https://github.com/SR1986).
#' @usage sl_regions_grid1
#' @rdname grids
#' @md
NULL

#' @name us_census_div_grid1
#' @description
#' * **us_census_div_grid1:** Grid layout of US Census divisions. Image reference [here](https://camo.githubusercontent.com/154dc45aaff776642ac7a5ce257106f70c97d441/68747470733a2f2f7777772e6569612e676f762f636f6e73756d7074696f6e2f636f6d6d65726369616c2f696d616765732f63656e646976636f2e676966). Thanks to [mkiang](https://github.com/mkiang).
#' @usage us_census_div_grid1
#' @rdname grids
#' @md
NULL

#' @name ar_tucuman_province_grid1
#' @description
#' * **ar_tucuman_province_grid1:** Grid layout for Argentina Tucumán Province political divisions (departments) Image reference [here](https://camo.githubusercontent.com/03faf8f653fffe62e0beb2ad9d36cbcbce094c10/687474703a2f2f7777772e636f6d6f6c6c65676172612e636f6d2f696d616765732f617267656e74696e612f646570617274616d656e746f732d64652d6c612d70726f76696e6369612d64652d747563756d616e2e706e67). Thanks to [TuQmano](https://github.com/TuQmano).
#' @usage ar_tucuman_province_grid1
#' @rdname grids
#' @md
NULL

#' @name us_nh_counties_grid1
#' @description
#' * **us_nh_counties_grid1:** Grid layout for the 10 counties in New Hampshire. Image reference [here](https://en.wikipedia.org/wiki/List_of_counties_in_New_Hampshire#/media/File:New_Hampshire_Locator_Map.PNG). Thanks to [soungl](https://github.com/soungl).
#' @usage us_nh_counties_grid1
#' @rdname grids
#' @md
NULL

#' @name china_prov_grid2
#' @description
#' * **china_prov_grid2:** Grid layout for Provinces of China. Image reference [here](https://user-images.githubusercontent.com/36669758/37746305-f5c138f4-2d4f-11e8-8a48-2a21513ea828.png). Thanks to [jw2531](https://github.com/jw2531).
#' @usage china_prov_grid2
#' @rdname grids
#' @md
NULL

#' @name pl_voivodeships_grid1
#' @description
#' * **pl_voivodeships_grid1:** Grid layout for Polish voivodeships (provinces) Image reference [here](https://user-images.githubusercontent.com/5550348/37672220-69c03caa-2c65-11e8-857e-2955f25f55bf.png). Thanks to [erzk](https://github.com/erzk).
#' @usage pl_voivodeships_grid1
#' @rdname grids
#' @md
NULL

#' @name us_ia_counties_grid1
#' @description
#' * **us_ia_counties_grid1:** Grid layout for counties in Iowa Image reference [here](https://camo.githubusercontent.com/9a5e5d3c974c85a6d3ee87b1d2858940476e74c0/68747470733a2f2f7777772e6469676974616c2d746f706f2d6d6170732e636f6d2f636f756e74792d6d61702f696f77612d636f756e74792d6d61702e676966). Thanks to [jrennyb](https://github.com/jrennyb).
#' @usage us_ia_counties_grid1
#' @rdname grids
#' @md
NULL

#' @name us_id_counties_grid1
#' @description
#' * **us_id_counties_grid1:** Grid layout for counties in Idaho Image reference [here](https://camo.githubusercontent.com/dbe964d952ecd106d2a9f677950852f957be1281/68747470733a2f2f67656f6c6f67792e636f6d2f636f756e74792d6d61702f696461686f2d636f756e74792d6d61702e676966). Thanks to [hathawayj](https://github.com/hathawayj).
#' @usage us_id_counties_grid1
#' @rdname grids
#' @md
NULL

#' @name ar_cordoba_dep_grid1
#' @description
#' * **ar_cordoba_dep_grid1:** Grid layout for departments of Cordoba province in Argentina. Image reference [here](https://user-images.githubusercontent.com/12114624/38060507-45d03c66-32a8-11e8-81c0-3ef7675dbf4e.png). Thanks to [TuQmano](https://github.com/TuQmano).
#' @usage ar_cordoba_dep_grid1
#' @rdname grids
#' @md
NULL

#' @name us_fl_counties_grid1
#' @description
#' * **us_fl_counties_grid1:** Grid for Florida counties. Image reference [here](https://user-images.githubusercontent.com/1275592/38098066-df3a7690-332b-11e8-9e4f-9123379e412e.jpg). Thanks to [ejr248](https://github.com/ejr248).
#' @usage us_fl_counties_grid1
#' @rdname grids
#' @md
NULL

#' @name ar_buenosaires_communes_grid1
#' @description
#' * **ar_buenosaires_communes_grid1:** Grid for communes of Buenos Aires, Argentina. Image reference [here](https://camo.githubusercontent.com/1397b556f643333f5c0afbf074e12b316ea8f063/687474703a2f2f7777772e6e6f746963696172696f7375722e636f6d2e61722f77702d636f6e74656e742f75706c6f6164732f323031322f30322f434f4d4e41532d4d4150412e676966). Thanks to [TuQmano](https://github.com/TuQmano).
#' @usage ar_buenosaires_communes_grid1
#' @rdname grids
#' @md
NULL

#' @name nz_regions_grid2
#' @description
#' * **nz_regions_grid2:** Grid layout for regions of New Zealand. Image reference [here](https://camo.githubusercontent.com/3db8d49d196be1e70ed0ebd4dcedf6fefc8fcfed/68747470733a2f2f75706c6f61642e77696b696d656469612e6f72672f77696b6970656469612f636f6d6d6f6e732f7468756d622f322f32312f4e5a5f526567696f6e616c5f436f756e63696c735f616e645f5465727269746f7269616c5f417574686f7269746965735f323031372e7376672f3130303070782d4e5a5f526567696f6e616c5f436f756e63696c735f616e645f5465727269746f7269616c5f417574686f7269746965735f323031372e7376672e706e67). Thanks to [pierreroudier](https://github.com/pierreroudier).
#' @usage nz_regions_grid2
#' @rdname grids
#' @md
NULL

#' @name oecd_grid1
#' @description
#' * **oecd_grid1:** Grid layout for OECD member countries. Image reference [here](https://camo.githubusercontent.com/9afd6ca4c97374e8d5b69c73325937e6de57ade3/68747470733a2f2f75706c6f61642e77696b696d656469612e6f72672f77696b6970656469612f636f6d6d6f6e732f7468756d622f342f34632f4f4543445f6d656d6265725f7374617465735f6d61702e7376672f3130303070782d4f4543445f6d656d6265725f7374617465735f6d61702e7376672e706e67). Thanks to [arcruz0](https://github.com/arcruz0).
#' @usage oecd_grid1
#' @rdname grids
#' @md
NULL
