% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{bestfitplane}
\alias{bestfitplane}
\title{Finds the Best Fit Polynomial Plane}
\usage{
bestfitplane(x)
}
\arguments{
\item{x}{A raster or matrix.}
}
\value{
A raster or matrix of the same size as the input with values
  predicted from the best polynomial fit.
}
\description{
Finds the best fit polynomial plane for a surface. This
function tests least squares polynomial fits with orders of
0 - 3 and determines which order minimizes the error when the
fit is subtracted from the original image.
}
\examples{
library(raster)

# import raster image
data(orforest)

# find the least squares polynomial plane
poly <- bestfitplane(orforest)

# plot the fit
plot(poly)
}
