% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geocode_reverso.R
\name{geocode_reverso}
\alias{geocode_reverso}
\title{Geocode reverso de coordenadas espaciais no Brasil}
\usage{
geocode_reverso(
  pontos,
  dist_max = 1000,
  verboso = TRUE,
  cache = TRUE,
  n_cores = 1
)
}
\arguments{
\item{pontos}{Uma tabela de dados com classe espacial \verb{sf data frame} no
sistema de coordenadas geográficas SIRGAS 2000, EPSG 4674.}

\item{dist_max}{Integer. Distancia máxima aceitável (em metros) entre os
pontos de input e o endereço Por padrão, a distância é de 1000 metros.}

\item{verboso}{Um valor lógico. Indica se barras de progresso e mensagens
devem ser exibidas durante o download dos dados do CNEFE e a geocodificação
dos endereços. O padrão é \code{TRUE}.}

\item{cache}{Um valor lógico. Indica se os dados do CNEFE devem ser salvos ou
lidos do cache, reduzindo o tempo de processamento em chamadas futuras. O
padrão é \code{TRUE}. Quando \code{FALSE}, os dados do CNEFE são baixados para um
diretório temporário.}

\item{n_cores}{Um número. O número de núcleos de CPU a serem utilizados no
processamento dos dados. O padrão é 1.}
}
\value{
Retorna o \verb{sf data.frame} de input adicionado das colunas do endereço
encontrado. O output inclui uma coluna "distancia_metros" que indica
a distância entre o ponto de input e o endereço mais próximo
encontrado.
}
\description{
Geocode reverso de coordenadas geográficas para endereços. A função recebe um
\verb{sf data frame} com pontos e retorna o endereço mais próximo dando uma
distância máxima de busca.
}
\examples{
\dontshow{if (identical(tolower(Sys.getenv("NOT_CRAN")), "true")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(geocodebr)
library(sf)

# ler amostra de dados
pontos <- readRDS(
    system.file("extdata/pontos.rds", package = "geocodebr")
    )

pontos <- pontos[1:50,]

# geocode reverso
df_enderecos <- geocodebr::geocode_reverso(
  pontos = pontos,
  dist_max = 1000,
  verboso = TRUE,
  n_cores = 1
  )
\dontshow{\}) # examplesIf}
}
