% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering_evaluation.R
\name{calcexplainedInertia}
\alias{calcexplainedInertia}
\title{Explained inertia index}
\usage{
calcexplainedInertia(data, belongmatrix)
}
\arguments{
\item{data}{The original dataframe used for the classification (n*p)}

\item{belongmatrix}{A membership matrix (n*k)}
}
\value{
A float: the percentage of the total inertia explained
}
\description{
Calculate the explained inertia by a classification
}
\examples{
data(LyonIris)
AnalysisFields <-c("Lden","NO2","PM25","VegHautPrt","Pct0_14","Pct_65","Pct_Img",
"TxChom1564","Pct_brevet","NivVieMed")
dataset <- LyonIris@data[AnalysisFields]
queen <- spdep::poly2nb(LyonIris,queen=TRUE)
Wqueen <- spdep::nb2listw(queen,style="W")
result <- SFCMeans(dataset, Wqueen,k = 5, m = 1.5, alpha = 1.5, standardize = TRUE)
calcexplainedInertia(result$Data,result$Belongings)
}
