% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatial_indices.R
\name{calcELSA}
\alias{calcELSA}
\title{calculate ELSA statistic for a hard partition}
\usage{
calcELSA(object, nblistw = NULL, window = NULL, matdist = NULL)
}
\arguments{
\item{object}{A FCMres object, typically obtained from functions CMeans,
GCMeans, SFCMeans, SGFCMeans. Can also be a vector of categories. This vector must
be filled with integers starting from 1. -1 can be used to indicate missing categories.}

\item{nblistw}{A list.w object describing the neighbours typically produced
by the spdep package. Required if data is a dataframe, see the parameter window
if you use a list of rasters as input.}

\item{window}{A binary (0,1) matrix representing the neighbours spatial weights when working
with rasters. The matrix must have odd dimensions.}

\item{matdist}{A matrix representing the dissimilarity between the clusters. The matrix must
be squared and the diagonal must be filled with zeros.}
}
\value{
A depending of the input, a vector of ELSA values or a raster with the ELSA values.
}
\description{
Calculate ELSA statistic for a hard partition. This local indicator of
spatial autocorrelation can be used to determine where observations belong to different
clusters.
}
\details{
The ELSA index \insertCite{naimi2019elsa}{geocmeans} can be used to measure
local autocorrelation for a categorical variable. It varies between 0 and 1, 0 indicating
a perfect positive spatial autocorrelation and 1 a perfect heterogeneity. It is based on
the Shanon entropy index, and uses a measure of difference between categories. Thus it
can reflect that proximity of two similar categories is still a form of positive
autocorelation. The authors suggest to calculate the mean of the index at several lag
distance to create an entrogram which quantifies global spatial structure and can be
represented as a variogram-like graph.
}
\examples{
data(LyonIris)
AnalysisFields <-c("Lden","NO2","PM25","VegHautPrt","Pct0_14","Pct_65","Pct_Img",
"TxChom1564","Pct_brevet","NivVieMed")
dataset <- LyonIris@data[AnalysisFields]
queen <- spdep::poly2nb(LyonIris,queen=TRUE)
Wqueen <- spdep::nb2listw(queen,style="W")
result <- SFCMeans(dataset, Wqueen,k = 5, m = 1.5, alpha = 1.5, standardize = TRUE)
elsa_valus <- calcELSA(result)
}
