# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @title Calculate the centroids
#' @name calcCentroids
#' @description Calculate the new centroids of the clusters based on the membership matrix
#' for a classical FCM.
#' @param data A Numeric matrix representing the observed data with n rows
#'   and p columns
#' @param belongmatrix A n X k matrix giving for each observation n, its
#'   probability to belong to the cluster k
#' @param m A float representing the fuzziness degree
#' @return A a matrix with the centers calculated for each cluster
#' @keywords internal
NULL

calcCentroids <- function(data, belongmatrix, m) {
    .Call(`_geocmeans_calcCentroids`, data, belongmatrix, m)
}

#' @title Calculate the membership matrix
#' @name calcBelongMatrix
#' @description Calculate the membership matrix according to a set of centroids, the observed
#'  data and the fuzziness degree
#' @param centers A matrix or a dataframe representing the centers of the
#'    clusters with p columns and k rows
#' @param data A dataframe or matrix representing the observed data with n rows
#'    and p columns
#' @param m A float representing the fuzziness degree
#' @return A n * k matrix representing the probability of belonging of each
#'    observation to each cluster
#' @keywords internal
#'
calcBelongMatrix <- function(centers, data, m) {
    .Call(`_geocmeans_calcBelongMatrix`, centers, data, m)
}

#' @title Calculate the centroids of SFCM
#' @name calcSWFCCentroids
#' @description Calculate the new centroids of the clusters based on the membership matrix for SFCM
#' @param data A matrix representing the observed data with n rows and p columns
#' @param wdata A matrix representing the lagged observed data with nrows and p columns
#' @param belongmatrix A n X k matrix giving for each observation n, its
#'   probability to belong to the cluster k
#' @param m An integer representing the fuzziness degree
#' @param alpha A float representing the weight of the space in the analysis (0
#'   is a typical fuzzy-c-mean algorithm, 1 is balanced between the two
#'   dimensions, 2 is twice the weight for space)
#' @return A n X k matrix representing the belonging probabilities of each
#'   observation to each cluster
#' @keywords internal
#'
calcSWFCCentroids <- function(data, wdata, belongmatrix, m, alpha) {
    .Call(`_geocmeans_calcSWFCCentroids`, data, wdata, belongmatrix, m, alpha)
}

#' @title Calculate the membership matrix (spatial version)
#' @name calcSFCMBelongMatrix
#' @description Calculate the membership matrix (spatial version) according to a set of
#' centroids, the observed data, the fuzziness degree a neighbouring matrix and
#' a spatial weighting term
#' @param centers A matrix or a dataframe representing the centers of the
#'   clusters with p columns and k rows
#' @param data A matrix representing the observed data with n rows and p columns
#' @param wdata A matrix representing the lagged observed data with n rows and p columns
#' @param m A float representing the fuzziness degree
#' @param alpha A float representing the weight of the space in the analysis (0
#'   is a typical fuzzy-c-mean algorithm, 1 is balanced between the two
#'   dimensions, 2 is twice the weight for space)
#' @return A n * k matrix representing the belonging probabilities of each
#'   observation to each cluster
#' @keywords internal
#'
calcSFCMBelongMatrix <- function(centers, data, wdata, m, alpha) {
    .Call(`_geocmeans_calcSFCMBelongMatrix`, centers, data, wdata, m, alpha)
}

#' @title Calculate the generalized membership matrix
#' @name calcFGCMBelongMatrix
#' @description Calculate the generalized membership matrix according to a set of
#' centroids, the observed data, the fuzziness degree, and a beta parameter
#'
#' @param centers A matrix representing the centers of the
#'   clusters with p columns and k rows
#' @param data A matrix representing the observed data with n rows
#'   and p columns
#' @param m A float representing the fuzziness degree
#' @param beta A float for the beta parameter (control speed convergence and classification crispness)
#' @return A n * k matrix representing the belonging probabilities of each
#'   observation to each cluster
#' @keywords internal
#'
calcFGCMBelongMatrix <- function(centers, data, m, beta) {
    .Call(`_geocmeans_calcFGCMBelongMatrix`, centers, data, m, beta)
}

#' @title Calculate the generalized membership matrix (spatial version)
#' @name calcSFGCMBelongMatrix
#' @description Calculate the generalized membership matrix (spatial version)
#' @param centers A matrix representing the centers of the clusters with p
#'   columns and k rows
#' @param data A matrix representing the observed data with n rows and p columns
#' @param wdata A matrix representing the lagged observed data with n rows
#'   and p columns
#' @param m A float representing the fuzziness degree
#' @param alpha A float representing the weight of the space in the analysis (0
#'   is a typical fuzzy-c-mean algorithm, 1 is balanced between the two
#'   dimensions, 2 is twice the weight for space)
#' @param beta A float for the beta parameter (control speed convergence and classification crispness)
#' @return A n * k matrix representing the belonging probabilities of each
#'   observation to each cluster
#' @keywords internal
#'
calcSFGCMBelongMatrix <- function(centers, data, wdata, m, alpha, beta) {
    .Call(`_geocmeans_calcSFGCMBelongMatrix`, centers, data, wdata, m, alpha, beta)
}

#' @title focal euclidean distance on a matrix with a given window
#' @name focal_euclidean_mat_window
#' @param mat a matrix
#' @param window a numeric matrix (squared)
#' @return a matrix with the euclidean distance of each cell to
#' its neighbours.
#' @keywords internal
#' @export
#'
focal_euclidean_mat_window <- function(mat, window) {
    .Call(`_geocmeans_focal_euclidean_mat_window`, mat, window)
}

#' @title focal euclidean distance on a list of matrices
#' @name focal_euclidean
#' @param matrices a List of matrices with the same dimensions
#' @param window a numeric matrix
#' @return a matrix with the euclidean distance of each cell to
#' its neighbours.
#' @keywords internal
#' @export
#'
focal_euclidean_list <- function(matrices, window) {
    .Call(`_geocmeans_focal_euclidean_list`, matrices, window)
}

#' @title focal euclidean distance on a matrix with a given window for a cube
#' @name focal_euclidean_arr_window
#' @param mat an array (cube)
#' @param window a numeric matrix (squared)
#' @return a matrix with the euclidean distance of each cell to
#' its neighbours.
#' @keywords internal
#' @export
#'
focal_euclidean_arr_window <- function(mat, window) {
    .Call(`_geocmeans_focal_euclidean_arr_window`, mat, window)
}

#' @title focal mean weighted by inverse of euclidean distance on a cube
#' @name focal_adj_mean_arr_window
#' @param mat an array (cube)
#' @param window a numeric matrix (squared)
#' @return a lagged version of the original cube
#' @keywords internal
#' @export
#'
focal_adj_mean_arr_window <- function(mat, window) {
    .Call(`_geocmeans_focal_adj_mean_arr_window`, mat, window)
}

#' @title Jaccard similarity coefficient
#' @name calc_jaccard_idx
#' @description Calculate the Jaccard similarity coefficient
#' @param x A vector of positive reals
#' @param y A vector of positive reals
#' @return A double: the Jaccard similarity coefficient
#' @keywords internal
calc_jaccard_idx <- function(x, y) {
    .Call(`_geocmeans_calc_jaccard_idx`, x, y)
}

#' @title Jaccard similarity coefficient between columns of two matrices
#' @name calc_jaccard_mat
#' @description Calculate the Jaccard similarity coefficient between the
#' columns of two matrices
#' @param matX A matrix
#' @param matY A matrix
#' @return A matrix with the Jaccard index values
#' @keywords internal
calc_jaccard_mat <- function(matX, matY) {
    .Call(`_geocmeans_calc_jaccard_mat`, matX, matY)
}

#' @title Moran I calculated on a matrix with a given window
#' @name moranI_matrix_window
#' @param mat a matrix
#' @param window the window to use to define neighbours. 0 can be used to indicate that a cell is not a neighbour
#' @return a double, the value of Moran I
#' @keywords internal
#' @export
#'
moranI_matrix_window <- function(mat, window) {
    .Call(`_geocmeans_moranI_matrix_window`, mat, window)
}

#' @title Local Moran I calculated on a matrix with a given window
#' @name local_moranI_matrix_window
#' @param mat a matrix
#' @param window the window to use to define neighbours. 0 can be used to indicate that a cell is not a neighbour
#' @return a double, the value of Moran I
#' @keywords internal
#' @export
#'
local_moranI_matrix_window <- function(mat, window) {
    .Call(`_geocmeans_local_moranI_matrix_window`, mat, window)
}

#' @title Elsa statistic calculated on a matrix with a given window
#' @name Elsa_categorical_matrix_window
#' @description method described here : https://doi.org/10.1016/j.spasta.2018.10.001
#' @param mat an IntegerMatrix, must be filled with integer, -1 indicates NA values, categories must start at 0
#' @param window the window to use to define neighbours. 0 can be used to indicate that a cell is not a neighbour
#' @param dist a distance matrix between the categories
#' @return a NumericVector : the local values of ELSA
#' @keywords internal
#' @export
#'
Elsa_categorical_matrix_window <- function(mat, window, dist) {
    .Call(`_geocmeans_Elsa_categorical_matrix_window`, mat, window, dist)
}

#' @title Fuzzy Elsa statistic calculated on a matrix with a given window
#' @name Elsa_fuzzy_matrix_window
#' @description This is an extension to the fuzzy classification case for the Elsa statistic
#' @param mats An array, each slice must contains the membership values of one group
#' @param window the window to use to define neighbours. 0 can be used to indicate that a cell is not a neighbour
#' @param dist a distance matrix between the groups
#' @return a NumericVector : the local values of ELSA
#' @keywords internal
#' @export
#'
Elsa_fuzzy_matrix_window <- function(mats, window, dist) {
    .Call(`_geocmeans_Elsa_fuzzy_matrix_window`, mats, window, dist)
}

#' @title Adjusted spatial inconsistency index for rasters
#' @name adj_spconsist_arr_window_globstd
#' @param data an arma cube of dimension nr,nc,ns
#' @param memberships an arma cube of dimension nr, nc, ks
#' @param a matrix representing the neighbouring of each pixel
#' @return a double, the adjusted spatial inconsitency index
#' @keywords internal
#' @export
#'
adj_spconsist_arr_window_globstd <- function(data, memberships, window) {
    .Call(`_geocmeans_adj_spconsist_arr_window_globstd`, data, memberships, window)
}

#' @title minimum of a vector
#' @name vecmin
#' @param x a NumericVector
#' @return a double
#' @keywords internal
#' @export
#'
vecmin <- function(x) {
    .Call(`_geocmeans_vecmin`, x)
}

#' @title maximum of a vector
#' @name vecmin
#' @param x a NumericVector
#' @return a double
#' @keywords internal
#' @export
#'
vecmax <- function(x) {
    .Call(`_geocmeans_vecmax`, x)
}

#' @title power of a matrix
#' @name power_mat
#' @param x a matrix
#' @param p a float
#' @return x ** p
#' @export
#' @keywords internal
#'
power_mat <- function(x, p) {
    .Call(`_geocmeans_power_mat`, x, p)
}

#' @title euclidean distance between rows of a matrix and a vector
#' @name calcEuclideanDistance2
#' @param y a matrix
#' @param x a vector (same length as ncol(matrix))
#' @return a vector (same length as nrow(matrix))
#' @export
#' @keywords internal
#'
calcEuclideanDistance2 <- function(y, x) {
    .Call(`_geocmeans_calcEuclideanDistance2`, y, x)
}

#' @title euclidean distance between rows of a matrix and a vector (arma mode)
#' @name calcEuclideanDistance3
#' @param y a matrix
#' @param x a vector (same length as ncol(matrix))
#' @return a vector (same length as nrow(matrix))
#' @export
#' @keywords internal
#'
calcEuclideanDistance3 <- function(y, x) {
    .Call(`_geocmeans_calcEuclideanDistance3`, y, x)
}

#' @title sum of two matrices by column
#' @name add_matrices_bycol
#' @param x a matrix
#' @param y a matrix with the same dimensions
#' @return a matrix
#' @keywords internal
#' @export
#'
add_matrices_bycol <- function(x, y) {
    .Call(`_geocmeans_add_matrices_bycol`, x, y)
}

#' @title substraction of two matrices by column
#' @name sub_matrices_bycol
#' @param x a matrix
#' @param y a matrix with the same dimensions
#' @return a matrix
#' @keywords internal
#' @export
#'
sub_matrices_bycol <- function(x, y) {
    .Call(`_geocmeans_sub_matrices_bycol`, x, y)
}

#' @title element wise product of two matrices by column
#' @name prod_matrices_bycol
#' @param x a matrix
#' @param y a matrix with the same dimensions
#' @return a matrix
#' @keywords internal
#' @export
#'
prod_matrices_bycol <- function(x, y) {
    .Call(`_geocmeans_prod_matrices_bycol`, x, y)
}

#' @title element wise division of two matrices by column
#' @name div_matrices_bycol
#' @param x a matrix
#' @param y a matrix with the same dimensions
#' @return a matrix
#' @keywords internal
#' @export
#'
div_matrices_bycol <- function(x, y) {
    .Call(`_geocmeans_div_matrices_bycol`, x, y)
}

#' @title element wise square root of a matrix by column
#' @name sqrt_matrix_bycol
#' @param x a matrix
#' @return a matrix
#' @keywords internal
#' @export
#'
sqrt_matrix_bycol <- function(x) {
    .Call(`_geocmeans_sqrt_matrix_bycol`, x)
}

#' @title element wise power of a matrix by column
#' @name pow_matrices_bycol
#' @param x a matrix
#' @param p the exponent
#' @return a matrix
#' @keywords internal
#' @export
#'
pow_matrix_bycol <- function(x, p) {
    .Call(`_geocmeans_pow_matrix_bycol`, x, p)
}

#' @title minimum of each row of a matrix
#' @name rowmins_mat
#' @param x a matrix
#' @return a NumericVector
#' @keywords internal
#' @export
#'
rowmins_mat <- function(x) {
    .Call(`_geocmeans_rowmins_mat`, x)
}

#' @title maximum in a matrix
#' @name max_mat
#' @param x a matrix
#' @return a double
#' @keywords internal
#' @export
#'
max_mat <- function(x) {
    .Call(`_geocmeans_max_mat`, x)
}

#' @title create a logical matrix with inferior comparison
#' @name test_inferior_mat
#' @param mat a matrix
#' @param t a double to compare
#' @return a LogicalMatrix
#' @keywords internal
#' @export
#'
test_inferior_mat <- function(mat, t) {
    .Call(`_geocmeans_test_inferior_mat`, mat, t)
}

#' @title create a matrix by multiplying a vector by its elements one by one as rows
#' @name vector_out_prod
#' @param x a vector
#' @return a NumericMatrix
#' @keywords internal
#' @export
#'
vector_out_prod <- function(x) {
    .Call(`_geocmeans_vector_out_prod`, x)
}

