% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_weighting_area.R
\name{read_weighting_area}
\alias{read_weighting_area}
\title{Download spatial data of Census Weighting Areas (area de ponderacao) of the Brazilian Population Census}
\usage{
read_weighting_area(
  code_weighting = "all",
  year = 2010,
  simplified = TRUE,
  showProgress = TRUE
)
}
\arguments{
\item{code_weighting}{The 7-digit code of a Municipality. If the two-digit code
or a two-letter uppercase abbreviation of a state is passed, (e.g. 33 or "RJ")
the function will load all weighting areas of that state. If \code{code_weighting="all"},
all weighting areas of the country are loaded.}

\item{year}{Year of the data. Defaults to \code{2010}}

\item{simplified}{Logic \code{FALSE} or \code{TRUE}, indicating whether the function returns
the data set with 'original' resolution or a data set with 'simplified' borders.
Defaults to \code{TRUE}. For spatial analysis and statistics users should set
\code{simplified = FALSE}. Borders have been simplified by removing vertices of
borders using \verb{st_simplify\{sf\}} preserving topology with a \code{dTolerance} of 100.}

\item{showProgress}{Logical. Defaults to \code{TRUE} display progress bar}
}
\value{
An \verb{"sf" "data.frame"} object
}
\description{
Only 2010 data is currently available.
}
\examples{
\dontrun{ if (interactive()) {
# Read specific weighting area at a given year
w <- read_weighting_area(code_weighting=5201108005004, year=2010)

# Read all weighting areas of a state at a given year
w <- read_weighting_area(code_weighting=53, year=2010) # or
w <- read_weighting_area(code_weighting="DF", year=2010)
plot(w)

# Read all weighting areas of a municipality at a given year
w <- read_weighting_area(code_weighting=5201108, year=2010)
plot(w)

# Read all weighting areas of the country at a given year
w <- read_weighting_area(code_weighting="all", year=2010)
} }
}
\seealso{
Other general area functions: 
\code{\link{read_amazon}()},
\code{\link{read_biomes}()},
\code{\link{read_census_tract}()},
\code{\link{read_comparable_areas}()},
\code{\link{read_conservation_units}()},
\code{\link{read_country}()},
\code{\link{read_health_region}()},
\code{\link{read_immediate_region}()},
\code{\link{read_intermediate_region}()},
\code{\link{read_meso_region}()},
\code{\link{read_micro_region}()},
\code{\link{read_municipality}()},
\code{\link{read_neighborhood}()},
\code{\link{read_region}()},
\code{\link{read_semiarid}()},
\code{\link{read_state}()},
\code{\link{read_statistical_grid}()}
}
\concept{general area functions}
