% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SpcList-Methods.R
\name{spc.make.stindex}
\alias{spc.make.stindex}
\title{Create a spatio-temporal index based on a list of \code{Spectra} objects}
\usage{
spc.make.stindex(
  input,
  what2include = "",
  rowSimplify = "none",
  includeTIME = FALSE,
  includeLATLON = FALSE
)
}
\arguments{
\item{input}{An object of class \code{spectra}}

\item{what2include}{A character variable giving the data columns to be included in the output}

\item{rowSimplify}{Either of "none", "spc.colMeans","firstRow" or "lastRow". Default is "none"}

\item{includeTIME}{Logical. Whether of not to include TIME data in the output STIDF object. Default is FALSE.}

\item{includeLATLON}{Logical. Whether of not to include LAT&LON data in the output STIDF object. Default is FALSE.}
}
\value{
An object of class \code{STIDF}. Each row of the output object has a space and time 
characteristics depending of the input argument \code{rowSimplify}.
}
\description{
Given a list of \code{Spectra} objects, this function creates a STIDF object summarizing the
spatial and temporal variability of the input dataset. Upon request, it also includes
data columns.
}
\details{
This function accepts a list of \code{Spectra} objects and outputs one STIDF object summarizing 
spatial and temporal variation of the input dataset. 

If rowSimplify="none", length of the output object will be equal to the sum of all rows of 
all elements of the input list object.

If rowSimplify="spc.colMeans", length of the output object will be equal to the number of rows of 
the input list object. 
This option returns the measurement nearest to the average time of each element of the input list.

firstRow and lastRow : length of the output object equals the number of rows of the input list object.
These two options return the first and last measurements of the input list element
}
\examples{
sp = spc.example_spectra()
BL = spc.makeSpcList(sp,"STATION")
stidx = spc.make.stindex(BL)
dim(stidx)
stidx = spc.make.stindex(BL, what2include = "CAST")
head(stidx@data)
stidx = spc.make.stindex(BL, rowSimplify="spc.colMeans")
dim(stidx)

}
\seealso{
\code{\link{spc.makeSpcList}}
}
