% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Spectra-Methods.R
\name{$,Spectra-method}
\alias{$,Spectra-method}
\alias{$,Spectra}
\alias{$<-,Spectra-method}
\alias{$<-,Spectra}
\alias{[,Spectra-method}
\alias{[[,Spectra,character,missing-method}
\alias{[[<-,Spectra,character,missing-method}
\title{Extract or replace parts of a \code{Spectra} object}
\usage{
\S4method{$}{Spectra}(x, name)

\S4method{$}{Spectra}(x, name) <- value

\S4method{[}{Spectra}(x, i, j)

\S4method{[[}{Spectra,character,missing}(x, i, j)

\S4method{[[}{Spectra,character,missing}(x, i, j) <- value
}
\arguments{
\item{x}{A \code{Spectra} object from which to extract element(s) or in which to replace element(s)}

\item{name}{A character (column name) or a numeric (column index) variable}

\item{value}{A vector or matrix or data.frame. Values to be replaced with matched \code{Spectra} column.}

\item{i}{A numeric (row index) variable}

\item{j}{A character (column name) or a numeric (column index) variable}
}
\description{
Operators acting on \code{Spectra} objects to extract parts

Operators acting on \code{Spectra} object and \code{Spectra} lists to extract or replace parts.
}
\details{
These operators are generic. You can write methods to handle indexing of specific classes of objects
}
\examples{
 sp<-spc.example_spectra()
 # spc.colnames() is used to extract column names
 head(spc.colnames(sp))
 head(sp$anap_300)
 sp[,"anap_345"]
 sp[,"anap_345"] #returns Spectra object with only one channel (column)
 sp[1:3,"anap_345"] #returns Spectra object with first 3 rows and only one channel (column)
 # spc.colnames() is used to extract column names
 head(spc.colnames(sp))
 head(sp$anap_300)
 sp[,"anap_345"]
sp=spc.example_spectra()
sp #501 spectral channels in columns and 26 observations in rows 
sp[1] #returns Spectra object, 501 spectral channels in columns and 1 observations in rows
names(sp)
sp[["CAST"]] #returns the CAST data column
sp[[4]] #returns the CAST data column
sp[["CAST"]]=12 #Modify the CAST column
sp[["CAST"]] #returns the CAST data column

}
