% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/frame2gpx.R
\name{frame2gpx}
\alias{frame2gpx}
\title{Convert latlon data frame to gpx file.}
\usage{
frame2gpx(data, filename = "tmp.gpx", type = "rte")
}
\arguments{
\item{data}{Data frame with positions in columns \code{lat} and \code{lon}.}

\item{filename}{Name of gpx-file, defaults to 'tmp.gpx'.}

\item{type}{Type of gpx-file, one of \code{wpt} for waypoints, \code{rte}'
for route or \code{trk} for track.}
}
\description{
Writes a gpx file of a dataframe with a call to \code{gpsbabel} in the shell
}
\note{
Requires \code{gpsbabel} installation working from the command line.
}
\examples{
\dontrun{
# some positions
pos <- rPeri(323)
frame2gpx(pos)
system("more tmp.gpx")
system("rm tmp.gpx")
}
}
\seealso{
\url{gpsbabel.org}
}
\keyword{manip}

