% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rand_gen.R
\name{random_init_uniform}
\alias{random_init_uniform}
\title{Generates random numbers from a finite union of intervals.}
\usage{
random_init_uniform(n, lefts, rights)
}
\arguments{
\item{n}{An integer, the number of samples to return.}

\item{lefts}{A vector of numbers, must have the same length as \code{rights}. A non-empty vector of numbers (may contain \code{-Inf}), the left endpoints of a domain defined as a union of intervals. It is required that \code{lefts[i] <= rights[i] <= lefts[j]} for any \code{i < j}.}

\item{rights}{A vector of numbers, must have the same length as \code{lefts}. A non-empty vector of numbers (may contain \code{Inf}), the right endpoints of a domain defined as a union of intervals. It is required that \code{lefts[i] <= rights[i] <= lefts[j]} for any \code{i < j}.}
}
\value{
\code{n} random numbers from the union of intervals.
}
\description{
Generates random numbers from a finite union of intervals.
}
\details{
For each sample, a random bin \code{i} is uniformly chosen from 1 through \code{length(lefts)}; if the \code{lefts[i]} and \code{rights[i]} define a finite interval, a random uniform variable is drawn from the interval; if the interval is infinite, a truncated laplace variable with location 0 and scale 1 is drawn. Used for randomly generating initial points for generators of truncated multivariate distributions.
}
\examples{
hist(random_init_uniform(1e4, -Inf, Inf), breaks=200)
hist(random_init_uniform(1e4, c(0, 5), c(2, Inf)), breaks=200)
hist(random_init_uniform(1e4, c(-Inf, 0, 3), c(-3, 1, 12)), breaks=200)
hist(random_init_uniform(1e4, c(-5, 0), c(-2, 2)), breaks=200)
hist(random_init_uniform(1e4, c(-10, 1), c(-7, 10)), breaks=200)
hist(random_init_uniform(1e4, c(-Inf, 100), c(-100, Inf)), breaks=200)
hist(random_init_uniform(1e4, c(-100, -90), c(-95, -85)), breaks=200)
}
