% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/domain.R
\name{frac_pow}
\alias{frac_pow}
\title{Evaluate x^(a/b) and |x|^(a/b) with integer a and b with extension to conventional operations.}
\usage{
frac_pow(x, a, b, abs)
}
\arguments{
\item{x}{A number or a vector of numbers.}

\item{a}{An integer.}

\item{b}{An integer.}

\item{abs}{TRUE or FALSE.}
}
\value{
A vector of numbers of the same size as \code{x}. See details.
}
\description{
Evaluate x^(a/b) and |x|^(a/b) with integer a and b with extension to conventional operations (listed under details) that would otherwise result in \code{NaN}.
}
\details{
Replace \code{x} by \code{abs(x)} below if \code{abs == TRUE}.
If \code{a == 0 && b == 0}, returns \code{log(x)}.
If \code{a != 0 && b == 0}, returns \code{exp(a*x)}.
Otherwise, for \code{b != 0}, evaluates \code{x^(a/b)} with the following extensions.
\code{0^0} evaluates to \code{1}.
If \code{x < 0}, returns \code{(-1)^a * |x|^(a/b)} if \code{b} is odd, or \code{NaN} otherwise.
If \code{x == 0 && a < 0}, returns \code{NaN}.
}
\examples{
frac_pow(-5:5, 3, 2, TRUE) - abs(-5:5)^(3/2)
frac_pow(-5:5, 5, 3, FALSE) - sign(-5:5)^5*abs(-5:5)^(5/3)
frac_pow(-5:5, 2, 3, FALSE) - ((-5:5)^2)^(1/3)
frac_pow(c(-5:-1,1:5), 0, 0, TRUE) - log(abs(c(-5:-1,1:5)))
frac_pow(-5:5, 0, 1, FALSE) - 1
frac_pow(-5:5, 3, 0, FALSE) - exp(3*-5:5)
}
