% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/odds_ratio_function.R
\name{odds_ratio_function}
\alias{odds_ratio_function}
\title{Odds Ratio Function}
\usage{
odds_ratio_function(N = NULL, Case.Rate = NULL, k = NULL,
  MAF = NULL, power = NULL, risk_allele = TRUE, Alpha = 0.05,
  True.Model = "All", Test.Model = "All")
}
\arguments{
\item{N}{Vector of the desired sample size(s)}

\item{Case.Rate}{Vector of the proportion(s) of cases in the sample (cases/(cases + controls)). Either k or Case.Rate must be specified.}

\item{k}{Vector of the number of controls per case. Either k or Case.Rate must be specified.}

\item{MAF}{Vector of minor allele frequencies}

\item{power}{Vector of powers to detect}

\item{risk_allele}{Logical: If OR > 1, the allele is classified as a "risk allele"}

\item{Alpha}{the desired type 1 error rate(s)}

\item{True.Model}{A vector vector the true underlying genetic model(s): 'Dominant', 'Additive', 'Recessive' or 'All'}

\item{Test.Model}{A vector specifying the assumed genetic model(s) used in testing: 'Dominant', 'Additive', 'Recessive' or 'All'}
}
\value{
A data frame including the odds ratios for all combinations of the specified parameters
}
\description{
Calculates the odds ratio for a given power, at a given sample size, N, with type 1 error rate, Alpha
}
\examples{
or <- odds_ratio_function(N=c(100), Case.Rate=0.3, 
 k=NULL, MAF= 0.25, power=0.8, 
 Alpha = 0.05, risk_allele = TRUE, True.Model = 'All', Test.Model = 'All')

}
