% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotations.R
\name{get_referent}
\alias{get_referent}
\title{Retrieve metadata for a referent}
\usage{
get_referent(
  created_by_id,
  song_id,
  web_page_id,
  access_token = genius_token()
)
}
\arguments{
\item{created_by_id}{ID of a user to get referents for}

\item{song_id}{ID of a song to get referents for (pass only one of \code{song_id} and
\code{web_page_id})}

\item{web_page_id}{ID of a web page to get referents for (pass only one of \code{song_id} and
\code{web_page_id})}

\item{access_token}{Genius' client access token, defaults to \code{genius_token}}
}
\value{
a \code{genius_referent} object that contains the extracted content from the request,
the original JSON response object and the request path.
}
\description{
The Genius API lets you return data for a specific referent.
\code{get_referent} returns this data in full.
}
\details{
Referents are the sections of a piece of content to which annotations are attached.
Each referent is associated with a web page or a song and may have one or more annotations.
Referents can be searched by the document they are attached to or by the user that created them.
}
\examples{
\dontrun{
get_referent(song_id = 3039923)
}
}
\seealso{
Other annotation: 
\code{\link{get_annotation}()}
}
\concept{annotation}
