% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geno_to_char.R
\name{geno_to_char}
\alias{geno_to_char}
\title{Convert a genotype matrix from numeric to character codes}
\usage{
geno_to_char(X, bim)
}
\arguments{
\item{X}{The genotype matrix.
It must have values only in 0, 1, 2, and \code{NA}.}

\item{bim}{The variant table.
It is required to have the same number of rows as \code{X}, and to have at least two named columns \code{ref} and \code{alt} (alleles 1 and 2 in a plink BIM table).
These alleles can be arbitrary strings (i.e. not just SNPs but also indels, any single or multicharacter code, or even blank strings) except the forward slash character ("/") is not allowed anywhere in these strings (function stops if a slash is present), since in the output it is the delimiter string.
\code{ref} and \code{alt} alleles must be different at each locus.}
}
\value{
The genotype matrix reencoded as strings.
At one locus, if the two alleles (ref and alt) are 'A' and 'B', then the genotypes in the input are encoded as characters as: 0 -> 'B/B', 1 -> 'B/A', and 2 -> 'A/A'.
Thus, the numeric encoding counts the reference allele dosage.
\code{NA} values in input \code{X} remain \code{NA} in the output.
If the input genotype matrix had row and column names, these are inherited by the output matrix.
}
\description{
Given the genotype matrix \code{X} and \code{bim} table (as they are parsed by \code{\link[=read_plink]{read_plink()}}, this outputs a matrix of the same dimensions as \code{X} but with the numeric codes (all values in 0, 1, 2) translated to human-readable character codes (such as 'A/A', 'A/G', 'G/G', depending on which are the two alleles at the locus as given in the \code{bim} table, see return value).
}
\examples{
# a numeric/dosage genotype matrix with two loci (rows)
# and three individuals (columns)
X <- rbind( 0:2, c(0, NA, 2) )
# corresponding variant table (minimal case with just two required columns)
library(tibble)
bim <- tibble( ref = c('A', 'G'), alt = c('C', 'GT') )

# genotype matrix translated as characters
X_char <- geno_to_char( X, bim )
X_char

}
\seealso{
\code{\link[=read_plink]{read_plink()}},
\code{\link[=read_bed]{read_bed()}},
\code{\link[=read_bim]{read_bim()}}.
}
