% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/depMeas.R
\name{depMeas}
\alias{depMeas}
\title{depMeas Measure dependence between two vectors.}
\usage{
depMeas(x, y, blksiz = length(x))
}
\arguments{
\item{x}{{Vector of data on first variable}}

\item{y}{{Vector of data on second variable}}

\item{blksiz}{{block size, default blksiz =n, where n=rows in matrix
or no blocking is done}}
}
\value{
A measure of dependence.
}
\description{
An infant may depend on the mother for survival, but not vice versa.
Dependence relations need not be symmetric, yet correlation coefficients
are symmetric. One way to measure the extent of dependence is to find
the max of the absolute values of the two asymmetric correlations
using Vinod (2015) definition of generalized (asymmetric) correlation
coefficients.  It requires a kernel regression of x on y obtained by using 
the `np' package and its flipped version.  We use a block version of
`gmcmtx0'  called `gmcmtxBlk` to admit several bandwidths.
}
\note{
This function needs the gmcmtxBlk function which in turn needs the np package.
}
\examples{
library(generalCorr)
options(np.messages = FALSE)
x=1:20;y=sin(x)
depMeas(x,y,blksiz=20)

}
\references{
Vinod, H. D. `Generalized Correlation and Kernel Causality with
 Applications in Development Economics' in Communications in
 Statistics -Simulation and Computation, 2015,
 \url{https://doi.org/gffn86}

Vinod, H. D. 'Matrix Algebra Topics in Statistics and Economics
Using R', Chapter 4 in Handbook of Statistics: Computational Statistics
with R, Vol.32, co-editors: M. B. Rao and C.R. Rao. New York:
North Holland, Elsevier Science Publishers, 2014, pp. 143-176.
}
\seealso{
See Also \code{\link{gmcmtx0}} and \code{\link{gmcmtxBlk}}
}
\author{
Prof. H. D. Vinod, Economics Dept., Fordham University, NY
}
\concept{asymmetric  p-values}
