# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#'@name genepop-utils
#'@title Programming utilities 
#'@description \code{getVersion} returns the version number of the C++ code (the same number that identifies the C++ executable). \code{set_restriction(TRUE)} sets the maximum number of populations and of loci to 300.
#'@param set logical: whether to set restrictions on number of populations and of loci
getVersion <- function() {
    .Call('_genepop_getVersion', PACKAGE = 'genepop')
}

#' Set random generator seed (except for Mantel test)
#' @usage setRandomSeed(seed)
#' @param seed integer: the new seed
setRandomSeed <- function(seed) {
    invisible(.Call('_genepop_setRandomSeed', PACKAGE = 'genepop', seed))
}

#' Set random generator seed for Mantel test
#' @usage setMantelSeed(seed)
#' @param seed integer: the new seed
setMantelSeed <- function(seed) {
    invisible(.Call('_genepop_setMantelSeed', PACKAGE = 'genepop', seed))
}

RHWEachLocusEachPopulationHD <- function(inputFile, outputFile, enumeration, dememorization, batches, iterations) {
    .Call('_genepop_RHWEachLocusEachPopulationHD', PACKAGE = 'genepop', inputFile, outputFile, enumeration, dememorization, batches, iterations)
}

RHWEachLocusEachPopulationHE <- function(inputFile, outputFile, enumeration, dememorization, batches, iterations) {
    .Call('_genepop_RHWEachLocusEachPopulationHE', PACKAGE = 'genepop', inputFile, outputFile, enumeration, dememorization, batches, iterations)
}

RHWEachLocusEachPopulationProbability <- function(inputFile, outputFile, enumeration, dememorization, batches, iterations) {
    .Call('_genepop_RHWEachLocusEachPopulationProbability', PACKAGE = 'genepop', inputFile, outputFile, enumeration, dememorization, batches, iterations)
}

RHWGlobalHD <- function(inputFile, outputFile, dememorization, batches, iterations) {
    .Call('_genepop_RHWGlobalHD', PACKAGE = 'genepop', inputFile, outputFile, dememorization, batches, iterations)
}

RHWGlobalHE <- function(inputFile, outputFile, dememorization, batches, iterations) {
    .Call('_genepop_RHWGlobalHE', PACKAGE = 'genepop', inputFile, outputFile, dememorization, batches, iterations)
}

RHWEachLocusEachPopulationHDWithSettingsFile <- function(inputFile, outputFile, settingsFile) {
    .Call('_genepop_RHWEachLocusEachPopulationHDWithSettingsFile', PACKAGE = 'genepop', inputFile, outputFile, settingsFile)
}

RHWEachLocusEachPopulationHEWithSettingsFile <- function(inputFile, outputFile, settingsFile) {
    .Call('_genepop_RHWEachLocusEachPopulationHEWithSettingsFile', PACKAGE = 'genepop', inputFile, outputFile, settingsFile)
}

RHWEachLocusEachPopulationProbabilityWithSettingsFile <- function(inputFile, outputFile, settingsFile) {
    .Call('_genepop_RHWEachLocusEachPopulationProbabilityWithSettingsFile', PACKAGE = 'genepop', inputFile, outputFile, settingsFile)
}

RHWGlobalHDWithSettingsFile <- function(inputFile, outputFile, settingsFile) {
    .Call('_genepop_RHWGlobalHDWithSettingsFile', PACKAGE = 'genepop', inputFile, outputFile, settingsFile)
}

RHWGlobalHEWithSettingsFile <- function(inputFile, outputFile, settingsFile) {
    .Call('_genepop_RHWGlobalHEWithSettingsFile', PACKAGE = 'genepop', inputFile, outputFile, settingsFile)
}

RGDEachPairLociEachPopulation <- function(inputFile, outputFile, dememorization, batches, iterations) {
    .Call('_genepop_RGDEachPairLociEachPopulation', PACKAGE = 'genepop', inputFile, outputFile, dememorization, batches, iterations)
}

RGDGenotypicContingency <- function(inputFile, outputFile) {
    .Call('_genepop_RGDGenotypicContingency', PACKAGE = 'genepop', inputFile, outputFile)
}

RGDEachPairLociEachPopulationWithSettingsFile <- function(inputFile, outputFile, settingsFile) {
    .Call('_genepop_RGDEachPairLociEachPopulationWithSettingsFile', PACKAGE = 'genepop', inputFile, outputFile, settingsFile)
}

RPDGenicAllPopulationDifferentiation <- function(inputFile, outputFile, dememorization, batches, iterations) {
    .Call('_genepop_RPDGenicAllPopulationDifferentiation', PACKAGE = 'genepop', inputFile, outputFile, dememorization, batches, iterations)
}

RPDGenicAllPairPopulationDifferentiation <- function(inputFile, outputFile, dememorization, batches, iterations) {
    .Call('_genepop_RPDGenicAllPairPopulationDifferentiation', PACKAGE = 'genepop', inputFile, outputFile, dememorization, batches, iterations)
}

RPDGenotypicAllPopulationDifferentiation <- function(inputFile, outputFile, dememorization, batches, iterations) {
    .Call('_genepop_RPDGenotypicAllPopulationDifferentiation', PACKAGE = 'genepop', inputFile, outputFile, dememorization, batches, iterations)
}

RPDGenotypicAllPairPopulationDifferentiation <- function(inputFile, outputFile, dememorization, batches, iterations) {
    .Call('_genepop_RPDGenotypicAllPairPopulationDifferentiation', PACKAGE = 'genepop', inputFile, outputFile, dememorization, batches, iterations)
}

RPDGenicAllPopulationDifferentiationWithSettingsFile <- function(inputFile, outputFile, settingsFile) {
    .Call('_genepop_RPDGenicAllPopulationDifferentiationWithSettingsFile', PACKAGE = 'genepop', inputFile, outputFile, settingsFile)
}

RPDGenicAllPairPopulationDifferentiationWithSettingsFile <- function(inputFile, outputFile, settingsFile) {
    .Call('_genepop_RPDGenicAllPairPopulationDifferentiationWithSettingsFile', PACKAGE = 'genepop', inputFile, outputFile, settingsFile)
}

RPDGenotypicAllPopulationDifferentiationWithSettingsFile <- function(inputFile, outputFile, settingsFile) {
    .Call('_genepop_RPDGenotypicAllPopulationDifferentiationWithSettingsFile', PACKAGE = 'genepop', inputFile, outputFile, settingsFile)
}

RPDGenotypicAllPairPopulationDifferentiationWithSettingsFile <- function(inputFile, outputFile, settingsFile) {
    .Call('_genepop_RPDGenotypicAllPairPopulationDifferentiationWithSettingsFile', PACKAGE = 'genepop', inputFile, outputFile, settingsFile)
}

RAnalyzingSingleContingencyTable <- function(inputFile, dememorization, batches, iterations) {
    .Call('_genepop_RAnalyzingSingleContingencyTable', PACKAGE = 'genepop', inputFile, dememorization, batches, iterations)
}

RAnalyzingSingleContingencyTableWithSettingsFile <- function(inputFile, settingsFile) {
    .Call('_genepop_RAnalyzingSingleContingencyTableWithSettingsFile', PACKAGE = 'genepop', inputFile, settingsFile)
}

RNmEstimates <- function(inputFile, outputFile, dataType) {
    .Call('_genepop_RNmEstimates', PACKAGE = 'genepop', inputFile, outputFile, dataType)
}

RDescriptifAlleleAndGenotypeFrequenciesPerLocusPerSample <- function(inputFile, outputFile) {
    .Call('_genepop_RDescriptifAlleleAndGenotypeFrequenciesPerLocusPerSample', PACKAGE = 'genepop', inputFile, outputFile)
}

RDescriptifGeneDiversitiesAndFisUsingAlleleIdentity <- function(inputFile, outputFile, dataType) {
    .Call('_genepop_RDescriptifGeneDiversitiesAndFisUsingAlleleIdentity', PACKAGE = 'genepop', inputFile, outputFile, dataType)
}

RDescriptifGeneDiversitiesAndFisUsingAlleleSize <- function(inputFile, outputFile, dataType) {
    .Call('_genepop_RDescriptifGeneDiversitiesAndFisUsingAlleleSize', PACKAGE = 'genepop', inputFile, outputFile, dataType)
}

REstimatingSpatialStructureAlleleIdentyAllPopulations <- function(inputFile, outputFile, dataType) {
    .Call('_genepop_REstimatingSpatialStructureAlleleIdentyAllPopulations', PACKAGE = 'genepop', inputFile, outputFile, dataType)
}

REstimatingSpatialStructureAlleleIdentyAllPopulationsPairs <- function(inputFile, outputFile, dataType) {
    .Call('_genepop_REstimatingSpatialStructureAlleleIdentyAllPopulationsPairs', PACKAGE = 'genepop', inputFile, outputFile, dataType)
}

REstimatingSpatialStructureAlleleSizeAllPopulations <- function(inputFile, outputFile, dataType) {
    .Call('_genepop_REstimatingSpatialStructureAlleleSizeAllPopulations', PACKAGE = 'genepop', inputFile, outputFile, dataType)
}

REstimatingSpatialStructureAlleleSizeAllPopulationsPairs <- function(inputFile, outputFile, dataType) {
    .Call('_genepop_REstimatingSpatialStructureAlleleSizeAllPopulationsPairs', PACKAGE = 'genepop', inputFile, outputFile, dataType)
}

RIsolationByDistanceBetweenIndividuals <- function(inputFile, outputFile, dataType, statistic, geographicScale, CIcoverage, testPoint, minimalDistance, maximalDistance, mantelPermutations, mantelRankTest) {
    .Call('_genepop_RIsolationByDistanceBetweenIndividuals', PACKAGE = 'genepop', inputFile, outputFile, dataType, statistic, geographicScale, CIcoverage, testPoint, minimalDistance, maximalDistance, mantelPermutations, mantelRankTest)
}

RIsolationByDistanceBetweenGroups <- function(inputFile, outputFile, dataType, statistic, geographicScale, CIcoverage, testPoint, minimalDistance, maximalDistance, mantelPermutations, mantelRankTest) {
    .Call('_genepop_RIsolationByDistanceBetweenGroups', PACKAGE = 'genepop', inputFile, outputFile, dataType, statistic, geographicScale, CIcoverage, testPoint, minimalDistance, maximalDistance, mantelPermutations, mantelRankTest)
}

RIsolationByDistanceBetweenIndividualsWithSettingsFile <- function(inputFile, outputFile, settingsFile) {
    .Call('_genepop_RIsolationByDistanceBetweenIndividualsWithSettingsFile', PACKAGE = 'genepop', inputFile, outputFile, settingsFile)
}

RIsolationByDistanceBetweenGroupsWithSettingsFile <- function(inputFile, outputFile, settingsFile) {
    .Call('_genepop_RIsolationByDistanceBetweenGroupsWithSettingsFile', PACKAGE = 'genepop', inputFile, outputFile, settingsFile)
}

REcumenicismFstat <- function(inputFile, outputFile) {
    .Call('_genepop_REcumenicismFstat', PACKAGE = 'genepop', inputFile, outputFile)
}

REcumenicismBiosysLetter <- function(inputFile, outputFile) {
    .Call('_genepop_REcumenicismBiosysLetter', PACKAGE = 'genepop', inputFile, outputFile)
}

REcumenicismBiosysNumber <- function(inputFile, outputFile) {
    .Call('_genepop_REcumenicismBiosysNumber', PACKAGE = 'genepop', inputFile, outputFile)
}

REcumenicismLinkdos <- function(inputFile, outputFile) {
    .Call('_genepop_REcumenicismLinkdos', PACKAGE = 'genepop', inputFile, outputFile)
}

RNullAlleleEstimateAlleleFrequencies <- function(inputFile, outputFile, nullAlleleMethod, CIcoverage) {
    .Call('_genepop_RNullAlleleEstimateAlleleFrequencies', PACKAGE = 'genepop', inputFile, outputFile, nullAlleleMethod, CIcoverage)
}

RDiploidisationHaploidData <- function(inputFile, outputFile) {
    .Call('_genepop_RDiploidisationHaploidData', PACKAGE = 'genepop', inputFile, outputFile)
}

RRelabelingAlleles <- function(inputFile, outputFile) {
    .Call('_genepop_RRelabelingAlleles', PACKAGE = 'genepop', inputFile, outputFile)
}

RConversionToIndividualDataWithPopulationNames <- function(inputFile, outputFile) {
    .Call('_genepop_RConversionToIndividualDataWithPopulationNames', PACKAGE = 'genepop', inputFile, outputFile)
}

RConversionToIndividualDataWithIndividualNames <- function(inputFile, outputFile) {
    .Call('_genepop_RConversionToIndividualDataWithIndividualNames', PACKAGE = 'genepop', inputFile, outputFile)
}

RRandomSamplingOfHaploidGenotypesFromDiploidOnes <- function(inputFile, outputFile) {
    .Call('_genepop_RRandomSamplingOfHaploidGenotypesFromDiploidOnes', PACKAGE = 'genepop', inputFile, outputFile)
}

RNullAlleleEstimateAlleleFrequenciesWithSettingsFile <- function(inputFile, outputFile, settingsFile) {
    .Call('_genepop_RNullAlleleEstimateAlleleFrequenciesWithSettingsFile', PACKAGE = 'genepop', inputFile, outputFile, settingsFile)
}

RHWtableHD <- function(inputFile, enumeration, dememorization, batches, iterations) {
    .Call('_genepop_RHWtableHD', PACKAGE = 'genepop', inputFile, enumeration, dememorization, batches, iterations)
}

RHWtableHE <- function(inputFile, enumeration, dememorization, batches, iterations) {
    .Call('_genepop_RHWtableHE', PACKAGE = 'genepop', inputFile, enumeration, dememorization, batches, iterations)
}

RHWtableProbability <- function(inputFile, enumeration, dememorization, batches, iterations) {
    .Call('_genepop_RHWtableProbability', PACKAGE = 'genepop', inputFile, enumeration, dememorization, batches, iterations)
}

RHWtableAlleleFrequenciesExpectedGenotypesFis <- function(inputFile) {
    .Call('_genepop_RHWtableAlleleFrequenciesExpectedGenotypesFis', PACKAGE = 'genepop', inputFile)
}

RHWtableHDWithSettingsFile <- function(inputFile, settingsFile) {
    .Call('_genepop_RHWtableHDWithSettingsFile', PACKAGE = 'genepop', inputFile, settingsFile)
}

RHWtableHEWithSettingsFile <- function(inputFile, settingsFile) {
    .Call('_genepop_RHWtableHEWithSettingsFile', PACKAGE = 'genepop', inputFile, settingsFile)
}

RHWtableProbabilityWithSettingsFile <- function(inputFile, settingsFile) {
    .Call('_genepop_RHWtableProbabilityWithSettingsFile', PACKAGE = 'genepop', inputFile, settingsFile)
}

Rinterrupt_genepop <- function() {
    invisible(.Call('_genepop_Rinterrupt_genepop', PACKAGE = 'genepop'))
}

Rset_restriction <- function(set) {
    invisible(.Call('_genepop_Rset_restriction', PACKAGE = 'genepop', set))
}

