/*
 * Decompiled with CFR 0.152.
 */
package org.drugis.mtc.summary;

import org.drugis.common.beans.AbstractObservable;
import org.drugis.mtc.MCMCResults;
import org.drugis.mtc.MCMCResultsEvent;
import org.drugis.mtc.MCMCResultsListener;
import org.drugis.mtc.Parameter;
import org.drugis.mtc.convergence.GelmanRubinConvergence;
import org.drugis.mtc.summary.Summary;

public class ConvergenceSummary
extends AbstractObservable
implements Summary {
    public static final String PROPERTY_PSRF = "scaleReduction";
    private final MCMCResults d_results;
    private final Parameter d_parameter;
    private double d_convergence;
    private boolean d_defined = false;

    public ConvergenceSummary(MCMCResults results, Parameter parameter) {
        this.d_results = results;
        this.d_parameter = parameter;
        this.d_results.addResultsListener(new MCMCResultsListener(){

            public void resultsEvent(MCMCResultsEvent event) {
                ConvergenceSummary.this.calc();
            }
        });
        if (this.d_results.getNumberOfSamples() > 0) {
            this.calc();
        }
    }

    public ConvergenceSummary(double convergence) {
        this.d_results = null;
        this.d_parameter = null;
        this.d_convergence = convergence;
        this.d_defined = true;
    }

    private void calc() {
        this.d_convergence = GelmanRubinConvergence.diagnose(this.d_results, this.d_parameter);
        this.d_defined = true;
        this.firePropertyChange(PROPERTY_PSRF, null, this.d_convergence);
        this.firePropertyChange("defined", false, true);
    }

    public boolean getDefined() {
        return this.d_defined;
    }

    public double getScaleReduction() {
        return this.d_convergence;
    }
}

