/*
 * Decompiled with CFR 0.152.
 */
package gov.lanl.yadas;

import gov.lanl.yadas.TunablePerturber;
import java.util.Random;

public class StandardPerturber
implements TunablePerturber {
    double[] mss;
    int which;
    static Random rand = new Random(System.currentTimeMillis());

    public StandardPerturber(double[] mss) {
        this(mss, 0);
    }

    public StandardPerturber(double[] mss, int which) {
        this.mss = mss;
        this.which = which;
    }

    public StandardPerturber(int which, double[] mss) {
        this(mss, which);
    }

    public void perturb(double[][] candarray, int whoseTurn) {
        double temp = this.mss[whoseTurn] * rand.nextGaussian();
        double[] dArray = candarray[this.which];
        int n = whoseTurn;
        dArray[n] = dArray[n] + temp;
    }

    public int numTurns() {
        return this.mss.length;
    }

    public double jacobian() {
        return 1.0;
    }

    public double[] getStepSizes() {
        double[] tem = new double[this.mss.length];
        System.arraycopy(this.mss, 0, tem, 0, this.mss.length);
        return tem;
    }

    public void setStepSize(double s, int i) {
        this.mss[i] = s;
    }

    public void setStepSizes(double[] s) {
        System.arraycopy(s, 0, this.mss, 0, s.length);
    }
}

