/*
 * Decompiled with CFR 0.152.
 */
package gov.lanl.yadas;

import gov.lanl.yadas.JumpPerturber;
import gov.lanl.yadas.TunablePerturber;
import java.util.Random;

public class SplittingLogitPerturber
implements JumpPerturber,
TunablePerturber {
    int which;
    double[] mss;
    double scale = 1.0;
    double adj = 1.0;
    static Random rand = new Random(System.currentTimeMillis());

    public SplittingLogitPerturber(int which, double[] mss) {
        this.which = which;
        this.mss = mss;
    }

    public void perturb(double[][] candarray, int whoseTurn) {
        for (int i = 0; i < this.mss.length; ++i) {
            this.adj = 1.0;
            this.scale = Math.exp(this.mss[i] * rand.nextGaussian());
            double temp = 1.0 / (1.0 + this.scale * (1.0 - candarray[this.which][i]) / candarray[this.which][i]);
            this.adj *= temp * (1.0 - temp) / candarray[this.which][i] / (1.0 - candarray[this.which][i]);
            candarray[this.which][i] = temp;
        }
    }

    public int numTurns() {
        return 1;
    }

    public double jacobian() {
        return this.adj;
    }

    public double density(double[][] oldarr, double[][] newarr, int whoseTurn) {
        double out = 1.0;
        for (int i = 0; i < this.mss.length; ++i) {
            double temp = oldarr[this.which][i];
            temp = Math.log(temp / (1.0 - temp));
            double temp1 = newarr[this.which][i];
            temp1 = Math.log(temp1 / (1.0 - temp1));
            out *= 1.0 / Math.sqrt(Math.PI * 2) / this.mss[i] * Math.exp(-(temp - temp1) * (temp - temp1) / 2.0 / this.mss[i] / this.mss[i]) / newarr[this.which][i] / (1.0 - newarr[this.which][i]);
        }
        return out;
    }

    public double[] getStepSizes() {
        double[] tem = new double[this.mss.length];
        System.arraycopy(this.mss, 0, tem, 0, this.mss.length);
        return tem;
    }

    public void setStepSize(double s, int i) {
        this.mss[i] = s;
    }

    public void setStepSizes(double[] s) {
        System.arraycopy(s, 0, this.mss, 0, s.length);
    }
}

