/*
 * Decompiled with CFR 0.152.
 */
package gov.lanl.yadas;

import gov.lanl.yadas.JumpPerturber;
import gov.lanl.yadas.MCMCBond;
import gov.lanl.yadas.MCMCParameter;
import gov.lanl.yadas.MCMCUpdate;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;

public class ReversibleJumpUpdate
implements MCMCUpdate {
    public static int numoutputs = 0;
    private boolean firstupdateoutput = true;
    private String stringvalue = "";
    PrintWriter out;
    private String direc = "";
    NumberFormat nf;
    int current_state;
    int previous_state;
    int next_state;
    MCMCParameter[] params;
    int numstates;
    double[][] transitionmat;
    double[][] cdfmat;
    JumpPerturber[][] perturbers;
    private int whoseTurn = 0;
    private int numTurns;
    int n;
    int[] len;
    double[][] candarray;
    MCMCBond[] bonds;
    private int[] num;
    private int[][] whatami;
    static Random rand = new Random(System.currentTimeMillis());
    static boolean warned = false;
    double[][] oldcands;
    int[][][] acceptances;
    int[][][] attempts;

    public ReversibleJumpUpdate(MCMCParameter[] params, int numstates, int initial_state, double[] transitionprobs, JumpPerturber[] perturberarray) {
        this(params, numstates, initial_state, transitionprobs, perturberarray, "");
    }

    public ReversibleJumpUpdate(MCMCParameter[] params, int numstates, int initial_state, double[] transitionprobs, JumpPerturber[] perturberarray, String direc) {
        int j;
        int i;
        if (!warned) {
            System.out.println("Be sure to double check that you are not trying to update \nany constant parameters.  ReversibleJumpUpdate will let you do it.");
            warned = true;
        }
        this.nf = NumberFormat.getNumberInstance();
        this.nf.setMaximumFractionDigits(4);
        this.nf.setGroupingUsed(false);
        this.direc = direc;
        this.previous_state = this.current_state = initial_state;
        this.params = params;
        this.numstates = numstates;
        this.transitionmat = new double[numstates][numstates];
        this.cdfmat = new double[numstates][numstates];
        int k = 0;
        for (i = 0; i < numstates; ++i) {
            for (j = 0; j < numstates; ++j) {
                this.transitionmat[i][j] = transitionprobs[k];
                this.cdfmat[i][j] = transitionprobs[k++];
            }
        }
        for (i = 0; i < numstates; ++i) {
            for (j = 0; j < numstates - 1; ++j) {
                int ell = j + 1;
                while (ell < numstates) {
                    double[] dArray = this.cdfmat[i];
                    int n = ell++;
                    dArray[n] = dArray[n] + this.transitionmat[i][j];
                }
            }
        }
        this.perturbers = new JumpPerturber[numstates][numstates];
        k = 0;
        for (i = 0; i < numstates; ++i) {
            for (j = 0; j < numstates; ++j) {
                this.perturbers[i][j] = perturberarray[k++];
            }
        }
        this.acceptances = new int[numstates][numstates][];
        this.attempts = new int[numstates][numstates][];
        for (i = 0; i < numstates; ++i) {
            for (j = 0; j < numstates; ++j) {
                int n1 = this.perturbers[i][j].numTurns();
                if (i != j && n1 > 1) {
                    System.out.println("You may have an ingenious idea, but JumpPerturbers that change\nthe state have to have numTurns = 1.");
                    System.exit(0);
                }
                this.acceptances[i][j] = new int[n1];
                this.attempts[i][j] = new int[n1];
                for (int ell = 0; ell < n1; ++ell) {
                    this.acceptances[i][j][ell] = 0;
                    this.attempts[i][j][ell] = 0;
                }
            }
        }
        this.n = params.length;
        this.candarray = new double[this.n][];
        this.oldcands = new double[this.n][];
        this.len = new int[this.n];
        for (i = 0; i < this.n; ++i) {
            this.len[i] = params[i].length();
            this.candarray[i] = new double[this.len[i]];
            this.oldcands[i] = new double[this.len[i]];
        }
        HashSet<MCMCBond> bondset = new HashSet<MCMCBond>();
        for (int ii = 0; ii < this.n; ++ii) {
            MCMCBond[] b1 = params[ii].relevantBonds();
            for (int i2 = 0; i2 < b1.length; ++i2) {
                bondset.add(b1[i2]);
            }
        }
        MCMCBond[] b = new MCMCBond[bondset.size()];
        int jj = 0;
        Iterator x = bondset.iterator();
        while (x.hasNext()) {
            b[jj++] = (MCMCBond)x.next();
        }
        this.bonds = b;
        this.whatami = new int[this.bonds.length][];
        this.num = new int[this.bonds.length];
        for (int j2 = 0; j2 < this.bonds.length; ++j2) {
            this.num[j2] = 0;
            this.whatami[j2] = new int[this.n];
            ArrayList al = b[j2].getParamList();
            for (int i3 = 0; i3 < this.n; ++i3) {
                boolean contains1 = al.contains(params[i3]);
                if (contains1) {
                    this.whatami[j2][i3] = al.indexOf(params[i3]);
                    int n = j2;
                    this.num[n] = this.num[n] + 1;
                    continue;
                }
                this.whatami[j2][i3] = -1;
            }
        }
    }

    public void update() {
        double chooser = rand.nextDouble();
        this.next_state = this.numstates;
        while (this.next_state > 0 && this.cdfmat[this.current_state][this.next_state - 1] > chooser) {
            --this.next_state;
        }
        int turns = this.perturbers[this.current_state][this.next_state].numTurns();
        while (this.whoseTurn < turns) {
            double candidate = this.candidate()[0];
            double ap = this.acceptanceProbability();
            this.stringvalue = this.perturbers[this.current_state][this.next_state].toString() + "|" + this.nf.format(ap);
            int[] nArray = this.attempts[this.current_state][this.next_state];
            int n = this.whoseTurn;
            nArray[n] = nArray[n] + 1;
            if (ap > (double)rand.nextFloat()) {
                this.takeStep();
            }
            ++this.whoseTurn;
        }
        this.whoseTurn = 0;
    }

    public double[] candidate() {
        for (int i = 0; i < this.params.length; ++i) {
            System.arraycopy(this.params[i].value, 0, this.candarray[i], 0, this.len[i]);
            System.arraycopy(this.params[i].value, 0, this.oldcands[i], 0, this.len[i]);
        }
        this.perturbers[this.current_state][this.next_state].perturb(this.candarray, this.whoseTurn);
        return new double[]{0.0};
    }

    public MCMCBond[] relevantBonds() {
        return this.bonds;
    }

    public double acceptanceProbability() {
        double lr = 0.0;
        for (int j = 0; j < this.bonds.length; ++j) {
            int[] temp = this.whatami[j];
            int[] whatamivec = new int[this.num[j]];
            int[] whichvec = new int[this.num[j]];
            int k = 0;
            for (int i = 0; i < this.whatami[j].length; ++i) {
                if (this.whatami[j][i] < 0) continue;
                whichvec[k] = i;
                whatamivec[k] = this.whatami[j][i];
                ++k;
            }
            lr += this.bonds[j].compute(whatamivec, this.candarray, whichvec);
        }
        return Math.exp(lr) * this.transitionmat[this.next_state][this.current_state] / this.transitionmat[this.current_state][this.next_state] / this.perturbers[this.current_state][this.next_state].density(this.oldcands, this.candarray, this.whoseTurn) * this.perturbers[this.next_state][this.current_state].density(this.candarray, this.oldcands, this.whoseTurn);
    }

    public void takeStep() {
        for (int i = 0; i < this.n; ++i) {
            this.params[i].setValue(this.candarray[i]);
        }
        for (int j = 0; j < this.bonds.length; ++j) {
            this.bonds[j].revise();
        }
        int[] nArray = this.acceptances[this.current_state][this.next_state];
        int n = this.whoseTurn;
        nArray[n] = nArray[n] + 1;
        this.current_state = this.next_state;
    }

    public void ignoreBond(MCMCBond ignorable) {
        HashSet<MCMCBond> bondset = new HashSet<MCMCBond>();
        for (int j = 0; j < this.bonds.length; ++j) {
            bondset.add(this.bonds[j]);
        }
        boolean removed = bondset.remove(ignorable);
        if (!removed) {
            return;
        }
        this.bonds = new MCMCBond[bondset.size()];
        int k = 0;
        Iterator iter = bondset.iterator();
        while (iter.hasNext()) {
            this.bonds[k++] = (MCMCBond)iter.next();
        }
        this.whatami = new int[this.bonds.length][];
        this.num = new int[this.bonds.length];
        for (int j = 0; j < this.bonds.length; ++j) {
            this.num[j] = 0;
            this.whatami[j] = new int[this.n];
            ArrayList al = this.bonds[j].getParamList();
            for (int i = 0; i < this.n; ++i) {
                boolean contains1 = al.contains(this.params[i]);
                if (contains1) {
                    this.whatami[j][i] = al.indexOf(this.params[i]);
                    int n = j;
                    this.num[n] = this.num[n] + 1;
                    continue;
                }
                this.whatami[j][i] = -1;
            }
        }
        System.out.println("Update now considers " + this.bonds.length + " bonds");
    }

    public String accepted() {
        String ac = "";
        for (int i = 0; i < this.numstates; ++i) {
            for (int j = 0; j < this.numstates; ++j) {
                ac = ac + i + " -> " + j + ": ";
                for (int k = 0; k < this.acceptances[i][j].length; ++k) {
                    ac = ac + this.acceptances[i][j][k] + " / " + this.attempts[i][j][k] + "; ";
                }
                ac = ac + "\n";
            }
        }
        return ac;
    }

    public void updateoutput() {
        if (this.firstupdateoutput) {
            this.firstupdateoutput = false;
            try {
                this.out = new PrintWriter(new FileWriter(this.direc + "RJU" + numoutputs + ".out"));
            }
            catch (IOException e) {
                System.out.print("Error: " + e);
                System.exit(1);
            }
            ++numoutputs;
        }
        this.out.println(this.stringvalue);
    }

    public void finish() {
        if (!this.firstupdateoutput) {
            this.out.close();
        }
    }
}

