/*
 * Decompiled with CFR 0.152.
 */
package gov.lanl.yadas;

import gov.lanl.yadas.MCMCInput;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class ScalarFrame
implements MCMCInput {
    final int n = 1;
    int m;
    int mi;
    int md;
    int ms;
    String[] varnames;
    double[] values;
    String delimiter;

    public ScalarFrame(String filename) {
        this(filename, "|");
    }

    public ScalarFrame(String filename, String delimiter) {
        this.delimiter = delimiter;
        try {
            BufferedReader in = new BufferedReader(new FileReader(filename));
            ArrayList<String> tempvarnames = new ArrayList<String>();
            ArrayList<Double> tempvalues = new ArrayList<Double>();
            while (in.ready()) {
                String s = in.readLine();
                StringTokenizer t = new StringTokenizer(s, delimiter);
                tempvarnames.add(t.nextToken());
                if (t.hasMoreTokens()) {
                    tempvalues.add(new Double(Double.parseDouble(t.nextToken())));
                    continue;
                }
                System.out.println(filename + "had a line with a " + "variable " + "name and no value.");
                System.exit(0);
            }
            this.md = this.m = tempvarnames.size();
            this.ms = 0;
            this.mi = 0;
            this.varnames = new String[this.m];
            this.values = new double[this.m];
            for (int i = 0; i < this.m; ++i) {
                this.varnames[i] = (String)tempvarnames.get(i);
                this.values[i] = (Double)tempvalues.get(i);
            }
            String[] realnames = new String[tempvarnames.size()];
            System.arraycopy(this.varnames, 0, realnames, 0, this.md);
        }
        catch (IOException e) {
            System.out.print("Error: " + e);
            System.exit(1);
        }
    }

    public int length() {
        return 1;
    }

    public int getVariableLength() {
        return 1;
    }

    public double[][] getRealvars() {
        double[][] temp = new double[this.md][1];
        for (int ii = 0; ii < this.md; ++ii) {
            temp[ii][0] = this.values[ii];
        }
        return temp;
    }

    public int[][] getIntvars() {
        int[][] temp = new int[this.md][1];
        for (int ii = 0; ii < this.md; ++ii) {
            temp[ii][0] = (int)this.values[ii];
        }
        return temp;
    }

    public String[][] getStringvars() {
        String[][] temp = new String[this.md][1];
        for (int ii = 0; ii < this.md; ++ii) {
            temp[ii][0] = "" + this.values[ii];
        }
        return temp;
    }

    public double[] r(String varname) {
        int ii;
        for (ii = 0; ii < this.m && !varname.equals(this.varnames[ii]); ++ii) {
        }
        if (ii == this.m) {
            System.out.println("No variable by the name " + varname);
            System.exit(1);
        }
        double[] temp = new double[]{this.values[ii]};
        return temp;
    }

    public double[] r(String varname, int numcopies) {
        int ii;
        for (ii = 0; ii < this.m && !varname.equals(this.varnames[ii]); ++ii) {
        }
        if (ii == this.m) {
            System.out.println("No variable by the name " + varname);
            System.exit(1);
        }
        double[] temp = new double[numcopies];
        for (int jj = 0; jj < numcopies; ++jj) {
            temp[jj] = this.values[ii];
        }
        return temp;
    }

    public double[] r(double val) {
        double[] temp = new double[]{val};
        return temp;
    }

    public static double[] r(double val, int len) {
        double[] temp = new double[len];
        for (int ii = 0; ii < len; ++ii) {
            temp[ii] = val;
        }
        return temp;
    }

    public int[] i(String varname) {
        int ii;
        for (ii = 0; ii < this.m && !varname.equals(this.varnames[ii]); ++ii) {
        }
        if (ii == this.m) {
            System.out.println("No variable by the name " + varname);
            System.exit(1);
        }
        int[] temp = new int[]{(int)this.values[ii]};
        return temp;
    }

    public int[] i(int val) {
        int[] temp = new int[]{val};
        return temp;
    }

    public static int[] i(int val, int len) {
        int[] temp = new int[len];
        for (int ii = 0; ii < len; ++ii) {
            temp[ii] = val;
        }
        return temp;
    }

    public String[] s(String varname) {
        int ii;
        for (ii = 0; ii < this.m && !varname.equals(this.varnames[ii]); ++ii) {
        }
        if (ii == this.m) {
            System.out.println("No variable by the name " + varname);
            System.exit(1);
        }
        String[] temp = new String[]{"" + this.values[ii]};
        return temp;
    }

    public int[] u() {
        return new int[]{0};
    }

    public static int[] u(int len) {
        int[] temp = new int[len];
        for (int ii = 0; ii < len; ++ii) {
            temp[ii] = ii;
        }
        return temp;
    }

    public static int[] u(int len, int numcopies) {
        int[] temp = new int[len * numcopies];
        int ind = 0;
        for (int jj = 0; jj < numcopies; ++jj) {
            int ii = 0;
            while (ii < len) {
                temp[ind] = ii++;
                ++ind;
            }
        }
        return temp;
    }

    public static void main(String[] args) {
        System.out.print("Testing DataFrame.\n");
        System.out.println("No tests written yet.");
    }
}

