/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.binding.adapter;

import com.jgoodies.binding.adapter.Bindings;
import com.jgoodies.binding.adapter.ColorSelectionAdapter;
import com.jgoodies.binding.formatter.EmptyDateFormatter;
import com.jgoodies.binding.formatter.EmptyNumberFormatter;
import com.jgoodies.binding.list.SelectionInList;
import com.jgoodies.binding.value.ConverterFactory;
import com.jgoodies.binding.value.ValueModel;
import java.awt.Color;
import java.text.DateFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.MaskFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicComponentFactory {
    protected BasicComponentFactory() {
    }

    public static JCheckBox createCheckBox(ValueModel valueModel, String text) {
        JCheckBox checkBox = new JCheckBox(text);
        Bindings.bind(checkBox, valueModel);
        return checkBox;
    }

    public static JColorChooser createColorChooser(ValueModel valueModel) {
        if (valueModel.getValue() == null) {
            throw new NullPointerException("The initial value must not be null.");
        }
        JColorChooser colorChooser = new JColorChooser(new ColorSelectionAdapter(valueModel));
        return colorChooser;
    }

    public static JColorChooser createColorChooser(ValueModel valueModel, Color defaultColor) {
        if (defaultColor == null) {
            throw new NullPointerException("The default color must not be null.");
        }
        JColorChooser colorChooser = new JColorChooser(new ColorSelectionAdapter(valueModel, defaultColor));
        return colorChooser;
    }

    public static <E> JComboBox createComboBox(SelectionInList<E> selectionInList) {
        return BasicComponentFactory.createComboBox(selectionInList, null);
    }

    public static <E> JComboBox createComboBox(SelectionInList<E> selectionInList, ListCellRenderer cellRenderer) {
        JComboBox comboBox = new JComboBox();
        Bindings.bind(comboBox, selectionInList);
        if (cellRenderer != null) {
            comboBox.setRenderer(cellRenderer);
        }
        return comboBox;
    }

    public static JFormattedTextField createDateField(ValueModel valueModel) {
        DateFormat shortFormat = DateFormat.getDateInstance(3);
        shortFormat.setLenient(false);
        EmptyDateFormatter defaultFormatter = new EmptyDateFormatter(shortFormat);
        EmptyDateFormatter displayFormatter = new EmptyDateFormatter();
        DefaultFormatterFactory formatterFactory = new DefaultFormatterFactory(defaultFormatter, displayFormatter);
        return BasicComponentFactory.createFormattedTextField(valueModel, formatterFactory);
    }

    public static JFormattedTextField createFormattedTextField(ValueModel valueModel, Format format) {
        JFormattedTextField textField = new JFormattedTextField(format);
        Bindings.bind(textField, valueModel);
        return textField;
    }

    public static JFormattedTextField createFormattedTextField(ValueModel valueModel, JFormattedTextField.AbstractFormatter formatter) {
        JFormattedTextField textField = new JFormattedTextField(formatter);
        Bindings.bind(textField, valueModel);
        return textField;
    }

    public static JFormattedTextField createFormattedTextField(ValueModel valueModel, JFormattedTextField.AbstractFormatterFactory formatterFactory) {
        JFormattedTextField textField = new JFormattedTextField(formatterFactory);
        Bindings.bind(textField, valueModel);
        return textField;
    }

    public static JFormattedTextField createFormattedTextField(ValueModel valueModel, String mask) {
        MaskFormatter formatter = null;
        try {
            formatter = new MaskFormatter(mask);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Invalid mask '" + mask + "'.");
        }
        JFormattedTextField textField = new JFormattedTextField(formatter);
        Bindings.bind(textField, valueModel);
        return textField;
    }

    public static JFormattedTextField createIntegerField(ValueModel valueModel) {
        return BasicComponentFactory.createIntegerField(valueModel, NumberFormat.getIntegerInstance(), null);
    }

    public static JFormattedTextField createIntegerField(ValueModel valueModel, int emptyNumber) {
        return BasicComponentFactory.createIntegerField(valueModel, NumberFormat.getIntegerInstance(), emptyNumber);
    }

    public static JFormattedTextField createIntegerField(ValueModel valueModel, NumberFormat numberFormat) {
        return BasicComponentFactory.createIntegerField(valueModel, numberFormat, null);
    }

    public static JFormattedTextField createIntegerField(ValueModel valueModel, NumberFormat numberFormat, int emptyNumber) {
        return BasicComponentFactory.createIntegerField(valueModel, numberFormat, (Integer)emptyNumber);
    }

    public static JFormattedTextField createIntegerField(ValueModel valueModel, NumberFormat numberFormat, Integer emptyNumber) {
        EmptyNumberFormatter numberFormatter = new EmptyNumberFormatter(numberFormat, emptyNumber);
        numberFormatter.setValueClass(Integer.class);
        return BasicComponentFactory.createFormattedTextField(valueModel, numberFormatter);
    }

    public static JFormattedTextField createLongField(ValueModel valueModel) {
        return BasicComponentFactory.createLongField(valueModel, NumberFormat.getIntegerInstance(), null);
    }

    public static JFormattedTextField createLongField(ValueModel valueModel, long emptyNumber) {
        return BasicComponentFactory.createLongField(valueModel, NumberFormat.getIntegerInstance(), emptyNumber);
    }

    public static JFormattedTextField createLongField(ValueModel valueModel, NumberFormat numberFormat) {
        return BasicComponentFactory.createLongField(valueModel, numberFormat, null);
    }

    public static JFormattedTextField createLongField(ValueModel valueModel, NumberFormat numberFormat, long emptyNumber) {
        return BasicComponentFactory.createLongField(valueModel, numberFormat, (Long)emptyNumber);
    }

    public static JFormattedTextField createLongField(ValueModel valueModel, NumberFormat numberFormat, Long emptyNumber) {
        EmptyNumberFormatter numberFormatter = new EmptyNumberFormatter(numberFormat, emptyNumber);
        numberFormatter.setValueClass(Long.class);
        return BasicComponentFactory.createFormattedTextField(valueModel, numberFormatter);
    }

    public static JLabel createLabel(ValueModel valueModel) {
        JLabel label = new JLabel();
        Bindings.bind(label, valueModel);
        return label;
    }

    public static JLabel createLabel(ValueModel valueModel, Format format) {
        return BasicComponentFactory.createLabel(ConverterFactory.createStringConverter(valueModel, format));
    }

    public static <E> JList createList(SelectionInList<E> selectionInList) {
        return BasicComponentFactory.createList(selectionInList, null);
    }

    public static <E> JList createList(SelectionInList<E> selectionInList, ListCellRenderer cellRenderer) {
        JList list = new JList();
        Bindings.bind(list, selectionInList);
        if (cellRenderer != null) {
            list.setCellRenderer(cellRenderer);
        }
        return list;
    }

    public static JPasswordField createPasswordField(ValueModel valueModel) {
        return BasicComponentFactory.createPasswordField(valueModel, true);
    }

    public static JPasswordField createPasswordField(ValueModel valueModel, boolean commitOnFocusLost) {
        JPasswordField textField = new JPasswordField();
        Bindings.bind(textField, valueModel, commitOnFocusLost);
        return textField;
    }

    public static JRadioButton createRadioButton(ValueModel model, Object choice, String text) {
        JRadioButton radioButton = new JRadioButton(text);
        Bindings.bind(radioButton, model, choice);
        return radioButton;
    }

    public static JTextArea createTextArea(ValueModel valueModel) {
        return BasicComponentFactory.createTextArea(valueModel, true);
    }

    public static JTextArea createTextArea(ValueModel valueModel, boolean commitOnFocusLost) {
        JTextArea textArea = new JTextArea();
        Bindings.bind(textArea, valueModel, commitOnFocusLost);
        return textArea;
    }

    public static JTextField createTextField(ValueModel valueModel) {
        return BasicComponentFactory.createTextField(valueModel, true);
    }

    public static JTextField createTextField(ValueModel valueModel, boolean commitOnFocusLost) {
        JTextField textField = new JTextField();
        Bindings.bind(textField, valueModel, commitOnFocusLost);
        return textField;
    }
}

