% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elastic.R
\name{elastic}
\alias{elastic}
\alias{elastic.GEM}
\alias{coef.GEMglmnet}
\title{Elastic-net modeling of GEM objects.}
\usage{
elastic(gem, ...)

\method{elastic}{GEM}(
  gem,
  effect,
  alpha = 0.5,
  newdata = NULL,
  validation,
  segments = NULL,
  measure = measure,
  family = family,
  ...
)
}
\arguments{
\item{gem}{Object of class \code{GEM}.}

\item{...}{Additional arguments for \code{\link[glmnet]{glmnet}}.}

\item{effect}{The effect to be used as response.}

\item{alpha}{The elasticnet mixing parameter.}

\item{newdata}{Optional new data matrix for prediction.}

\item{validation}{Optional validation parameters.}

\item{segments}{number of segments or list of segments (optional)}

\item{measure}{Type of performance summary, default = 'class' (see \code{\link[glmnet]{glmnet}})}

\item{family}{Type of model response, default = 'multinomial'.}
}
\value{
An object of class \code{GEMglmnet, cv.glmnet, list} containing the fitted Elastic-net model, classifications/predictions and data.
}
\description{
Elastic-net modeling of GEM objects.
}
\examples{
## Multiple Sclerosis data
data(MS, package = "gemR")
# Subset to reduce runtime in example
MS$proteins <- MS$proteins[,20:70]

gem <- GEM(proteins ~ MS * group, data = MS)
elasticMod <- elastic(gem, 'MS', validation = "CV")
sum(elasticMod$classes == MS$MS)
plot(elasticMod)            # Model fit
plot(elasticMod$glmnet.fit) # Coefficient trajectories

# Select all proteins with non-zeros coefficients
coefs     <- coef(elasticMod)
(selected <- names(which(coefs[,1] != 0)))

\donttest{ # Time consuming due to many variables
  ## Diabetes data
  data(Diabetes, package = "gemR")
  gem.Dia <- GEM(transcriptome ~ surgery * T2D, data = Diabetes)
  elasticMod <- elastic(gem.Dia, 'T2D', validation = "LOO")
}
}
\seealso{
Analyses using \code{GEM}: \code{\link{pca}}, \code{\link{sca}}, \code{\link{neuralnet}}, \code{\link{pls}}.
Confidence interval plots: \code{\link{confints}}. Convenience knock-in and knock-out of effects: \code{\link{knock.in}}.
}
