% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qpgee.R
\name{qpgee}
\alias{qpgee}
\title{Quantile Penalized Generalized Estimating Equations (QPGEE)}
\usage{
qpgee(
  x,
  y,
  tau = 0.5,
  nk = rep(1, length(y)),
  worktype = "CS",
  lambda = 0.1,
  betaint = NULL,
  f0 = NULL,
  max_it = 100,
  cutoff = 10^-1
)
}
\arguments{
\item{x}{A matrix of predictors.}

\item{y}{A numeric vector of response variables.}

\item{tau}{The quantile to be estimated (default is 0.5, the median).}

\item{nk}{A numeric vector indicating the number of observations per subject.}

\item{worktype}{A string specifying the working correlation structure.
Options include "CS" (Compound Symmetry), "AR" (Autoregressive),
"Tri" (Tri-diagonal), and "Ind" (Independent).}

\item{lambda}{The penalty parameter for regularization (default is 0.1).}

\item{betaint}{Initial values for the beta coefficients. If NULL,
non-longitudinal quantile regression is used for initialization.}

\item{f0}{estimated conditional error distributions.}

\item{max_it}{Maximum number of iterations (default is 100).}

\item{cutoff}{Threshold for coefficient shrinkage (default is 0.1).}
}
\value{
A list containing the following components:
          \item{beta}{Estimated beta coefficients.}
          \item{g}{Fitted values of the linear predictor.}
          \item{R}{Estimated working correlation matrix.}
          \item{X_selected}{Indices of selected predictors.}
          \item{mcl}{Mean check loss.}
          \item{hbic}{Hannan-Quinn Information Criterion value.}
          \item{converge}{Boolean indicating whether the algorithm converged.}
}
\description{
This function implements Quantile Penalized Generalized Estimating Equations
(QPGEE) for longitudinal data analysis. It estimates parameters using a
penalized quantile regression approach within a GEE framework, allowing for
different working correlation structures.
}
\examples{
# Example usage:
sim_data <- generateData(n_sub = 100, n_obs = rep(10, 100),  p = 100,
                         beta0 = rep(1,7), rho = 0.6, type = "ar",
                          dis = "normal", ka = 1)

X=sim_data$X
y=sim_data$y

#fit qpgee
qpgee.fit = qpgee(X,y,tau=0.5,nk=rep(10, 100))
qpgee.fit$beta

}
