% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exchange_rate.R
\name{exchange_rate}
\alias{exchange_rate}
\title{Exchange rate}
\usage{
exchange_rate(currency = NULL, max_attempts = 3)
}
\arguments{
\item{currency}{(character or \code{NULL}): a vector with abbreviated names of the
currencies of interest. An up-to-date list of supported currencies (both
fiat and cryptocurrencies) can be retrieved with the \code{\link[=supported_currencies]{supported_currencies()}}
function. If an unsupported \code{currency} is requested, the call will fail
with the respective error message. If \code{currency = NULL} (default), the
function will return exchange rates for all supported currencies.}

\item{max_attempts}{(double, positive): specifies the
maximum number of attempts to call the CoinGecko API (e.g., if
the first call fails for some reason). Additional attempts are
implemented with an exponential backoff. Defaults to 3.}
}
\value{
A tibble with the following columns:
\itemize{
\item \code{timestamp} (POSIXct): date and time of the API request;
\item \code{currency} (character): abbreviated name of the currency;
\item \code{name} (character): common name of the currency;
\item \code{price_in_btc} (double): price in Bitcoin;
\item \code{type} (character): type of the currency (\code{"fiat"} or \code{"crypto"}).
}
}
\description{
Retrieves the current exchange rate for a crypto- of fiat currency in Bitcoin
}
\details{
This function is based on the public
\href{https://www.coingecko.com/api/documentations/v3}{CoinGecko API},
which has a limit of 50 calls per minute. Please
keep this limit in mind when developing your applications.
}
\examples{
\donttest{
# get exchange rates for all supported currencies
r1 <- exchange_rate()
print(r1)

# get exchange rates for a set of currencies:
r2 <- exchange_rate(currency = c("usd", "eur", "gbp"))
print(r2)
}
}
