% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coin_history.R
\name{coin_history}
\alias{coin_history}
\title{Get historical market data}
\usage{
coin_history(
  coin_id,
  vs_currency = "usd",
  days,
  interval = NULL,
  max_attempts = 3
)
}
\arguments{
\item{coin_id}{(character): ID of the coin of interest. An
up-to-date list of supported coins and their IDs can be retrieved
with the \code{\link[=supported_coins]{supported_coins()}} function.}

\item{vs_currency}{(character): name of the reference currency to
express the price in. An up-to-date list of supported reference currencies (both
fiat and cryptocurrencies) can be obtained with the \code{\link[=supported_currencies]{supported_currencies()}}
function. If an unsupported \code{vs_currency} is requested, the call will
fail with the respective error message.}

\item{days}{(numeric or \code{"max"}): number of days to look back.
If \code{days = "max"}, the entire available history for \code{coin_id} will be
retrieved. Depending on the value of \code{days}, the time interval used to
present the data will differ - see "Details".}

\item{interval}{(character or \code{NULL}): time interval used to present the data.
The only currently supported value is \code{daily}. Defaults to \code{NULL}.}

\item{max_attempts}{(double, positive): specifies the
maximum number of attempts to call the CoinGecko API (e.g., if
the first call fails for some reason). Additional attempts are
implemented with an exponential backoff. Defaults to 3.}
}
\value{
A tibble with the following columns:
\itemize{
\item \code{timestamp} (POSIXct);
\item \code{coin_id} (character): same as the argument \code{coin_id};
\item \code{vs_currency} (character): same as the argument \code{vs_currency};
\item \code{price} (double): coin price, as of \code{timestamp};
\item \code{total_volume} (double): a 24 hours rolling-window trading volume, as
of \code{timestamp};
\item \code{market_cap} (double): market capitalisation, as of \code{timestamp}.
}
}
\description{
Retrieves market data for a coin for the last \emph{n} days
}
\details{
If \code{days = 1} and \code{interval = NULL}, the data will be returned for
every few minutes (typically 3-8 minutes). If \code{days} is between 2 and 90
(inclusive) and \code{interval = NULL}, an (approximately) hourly time step will
be used. Daily data are used for \code{days} above 90. If \code{interval = "daily"},
daily data will be used irrespective of the value of \code{days}.

This function is based on the public
\href{https://www.coingecko.com/api/documentations/v3}{CoinGecko API},
which has a limit of 50 calls per minute. Please
keep this limit in mind when developing your applications.
}
\examples{
\donttest{
r <- coin_history(coin_id = "bitcoin", vs_currency = "usd", days = 30)
print(r)
}
}
