% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom.R
\name{g_make_valid}
\alias{g_make_valid}
\title{Attempt to make invalid geometries valid}
\usage{
g_make_valid(
  geom,
  method = "LINEWORK",
  keep_collapsed = FALSE,
  as_wkb = TRUE,
  as_iso = FALSE,
  byte_order = "LSB",
  quiet = FALSE
)
}
\arguments{
\item{geom}{Either a raw vector of WKB or list of raw vectors, or a
character vector containing one or more WKT strings.}

\item{method}{Character string. One of \code{"LINEWORK"} (the default) or
\code{"STRUCTURE"} (requires GEOS >= 3.10 and GDAL >= 3.4). See Details.}

\item{keep_collapsed}{Logical value, applies only to the STRUCTURE method.
Defaults to \code{FALSE}. See Details.}

\item{as_wkb}{Logical value, \code{TRUE} to return the output geometry in WKB
format (the default), or \code{FALSE} to return as WKT.}

\item{as_iso}{Logical value, \code{TRUE} to export as ISO WKB/WKT (ISO 13249
SQL/MM Part 3), or \code{FALSE} (the default) to export as "Extended WKB/WKT".}

\item{byte_order}{Character string specifying the byte order when output is
WKB. One of \code{"LSB"} (the default) or \code{"MSB"} (uncommon).}

\item{quiet}{Logical value, \code{TRUE} to suppress warnings. Defaults to \code{FALSE}.}
}
\value{
A geometry as WKB raw vector or WKT string, or a list/character vector of
geometries as WKB/WKT with length equal to \code{length(geom)}. \code{NA} is returned
with a warning if WKB input cannot be converted into an OGR geometry object,
or if an error occurs in the call to MakeValid() in the underlying OGR API.
}
\description{
\code{g_make_valid()} attempts to make an invalid geometry valid without losing
vertices. Already-valid geometries are cloned without further intervention.
Wrapper of \code{OGR_G_MakeValid()}/\code{OGR_G_MakeValidEx()} in the GDAL API.
}
\details{
LINEWORK is the default method, which combines all rings into a set of noded
lines and then extracts valid polygons from that linework. The STRUCTURE
method (requires GEOS >= 3.10 and GDAL >= 3.4) first makes all rings valid,
then merges shells and subtracts holes from shells to generate a valid
result. Assumes that holes and shells are correctly categorized.

KEEP_COLLAPSED only applies to the STRUCTURE method:
\itemize{
\item \code{FALSE} (the default): collapses are converted to empty geometries
\item \code{TRUE}: collapses are converted to a valid geometry of lower dimension
}
}
\note{
This function is built on the GEOS >= 3.8 library, check it for the
definition of the geometry operation. If OGR is built without GEOS >= 3.8,
this function will return a clone of the input geometry if it is valid, or
\code{NA} if it is invalid.
}
\examples{
# requires GEOS >= 3.8, otherwise is only a validity test (see Note)
geos_version()

# valid
wkt <- "POINT (0 0)"
g_make_valid(wkt, as_wkb = FALSE)

# invalid to valid
wkt <- "POLYGON ((0 0,10 10,0 10,10 0,0 0))"
g_make_valid(wkt, as_wkb = FALSE)

# invalid - error
wkt <- "LINESTRING (0 0)"
g_make_valid(wkt)  # NA
}
